/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.messaging.eventhubs.EventData;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.publisher.MonoSink;

final class FlushSignal
extends EventData {
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private final MonoSink<Void> sink;
    private final long id = COUNTER.getAndIncrement();

    FlushSignal(MonoSink<Void> sink) {
        super("FLUSH_SIGNAL");
        this.sink = Objects.requireNonNull(sink, "'sink' cannot be null");
    }

    long getId() {
        return this.id;
    }

    void flushed() {
        this.sink.success();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.id == ((FlushSignal)((Object)o)).id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }
}

