/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.messaging.eventhubs.implementation.AmqpReceiveLinkProcessor;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;

final class MessageFluxWrapper {
    private final AmqpReceiveLinkProcessor receiveLinkProcessor;
    private final Flux<Message> messageFlux;
    private final boolean isV2;

    MessageFluxWrapper(Flux<Message> messageFlux) {
        this.messageFlux = Objects.requireNonNull(messageFlux, "'messageFlux' cannot be null.");
        this.receiveLinkProcessor = null;
        this.isV2 = true;
    }

    MessageFluxWrapper(AmqpReceiveLinkProcessor receiveLinkProcessor) {
        this.receiveLinkProcessor = Objects.requireNonNull(receiveLinkProcessor, "'amqpReceiveLinkProcessor' cannot be null.");
        this.messageFlux = null;
        this.isV2 = false;
    }

    Flux<Message> flux() {
        return this.isV2 ? this.messageFlux : this.receiveLinkProcessor;
    }

    boolean isTerminated() {
        return this.isV2 ? false : this.receiveLinkProcessor.isTerminated();
    }

    void cancel() {
        if (!this.isV2) {
            this.receiveLinkProcessor.cancel();
        }
    }
}

