/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.Meter;
import com.azure.messaging.eventhubs.implementation.instrumentation.InstrumentationScope;
import com.azure.messaging.eventhubs.implementation.instrumentation.InstrumentationUtils;
import com.azure.messaging.eventhubs.implementation.instrumentation.OperationName;
import com.azure.messaging.eventhubs.models.Checkpoint;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EventHubsMetricsProvider {
    private final Meter meter;
    private final boolean isEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(EventHubsMetricsProvider.class);
    private Map<String, Object> commonAttributes;
    private AttributeCache sendAttributeCacheSuccess;
    private AttributeCache receiveAttributeCacheSuccess;
    private AttributeCache checkpointAttributeCacheSuccess;
    private AttributeCache processAttributeCacheSuccess;
    private AttributeCache getPartitionPropertiesAttributeCacheSuccess;
    private AttributeCache getEventHubPropertiesAttributeCacheSuccess;
    private AttributeCache lagAttributeCache;
    private LongCounter publishedEventCounter;
    private LongCounter consumedEventCounter;
    private DoubleHistogram operationDuration;
    private DoubleHistogram processDuration;
    private DoubleHistogram consumerLag;

    public EventHubsMetricsProvider(Meter meter, String namespace, String entityName, String consumerGroup) {
        this.meter = meter;
        boolean bl = this.isEnabled = meter != null && meter.isEnabled();
        if (this.isEnabled) {
            this.commonAttributes = this.getCommonAttributes(namespace, entityName, consumerGroup);
            this.sendAttributeCacheSuccess = AttributeCache.create(meter, OperationName.SEND, this.commonAttributes);
            this.receiveAttributeCacheSuccess = AttributeCache.create(meter, OperationName.RECEIVE, this.commonAttributes);
            this.checkpointAttributeCacheSuccess = AttributeCache.create(meter, OperationName.CHECKPOINT, this.commonAttributes);
            this.processAttributeCacheSuccess = AttributeCache.create(meter, OperationName.PROCESS, this.commonAttributes);
            this.getPartitionPropertiesAttributeCacheSuccess = AttributeCache.create(meter, OperationName.GET_PARTITION_PROPERTIES, this.commonAttributes);
            this.getEventHubPropertiesAttributeCacheSuccess = AttributeCache.create(meter, OperationName.GET_EVENT_HUB_PROPERTIES, this.commonAttributes);
            this.lagAttributeCache = new AttributeCache(meter, "messaging.destination.partition.id", this.commonAttributes);
            this.publishedEventCounter = meter.createLongCounter("messaging.client.published.messages", "The number of published events", "{event}");
            this.consumedEventCounter = meter.createLongCounter("messaging.client.consumed.messages", "The number of consumed events", "{event}");
            this.operationDuration = meter.createDoubleHistogram("messaging.client.operation.duration", "The duration of client messaging operations involving communication with the Event Hubs namespace", "s");
            this.processDuration = meter.createDoubleHistogram("messaging.process.duration", "The duration of the processing callback", "s");
            this.consumerLag = meter.createDoubleHistogram("messaging.eventhubs.consumer.lag", "Difference between local time when event was received and the local time it was enqueued on broker", "s");
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void reportBatchSend(int batchSize, String partitionId, InstrumentationScope scope) {
        if (this.isEnabled && (this.publishedEventCounter.isEnabled() || this.operationDuration.isEnabled())) {
            TelemetryAttributes attributes = this.getOrCreateAttributes(OperationName.SEND, partitionId, scope.getErrorType());
            this.publishedEventCounter.add((long)batchSize, attributes, scope.getSpan());
            this.operationDuration.record(InstrumentationUtils.getDurationInSeconds(scope.getStartTime()), attributes, scope.getSpan());
        }
    }

    public void reportProcess(int batchSize, String partitionId, InstrumentationScope scope) {
        if (this.isEnabled && (this.consumedEventCounter.isEnabled() || this.processDuration.isEnabled())) {
            TelemetryAttributes attributes = this.getOrCreateAttributes(OperationName.PROCESS, partitionId, scope.getErrorType());
            this.consumedEventCounter.add((long)batchSize, attributes, scope.getSpan());
            this.processDuration.record(InstrumentationUtils.getDurationInSeconds(scope.getStartTime()), attributes, scope.getSpan());
        }
    }

    public void reportReceive(int receivedCount, String partitionId, InstrumentationScope scope) {
        if (this.isEnabled && (this.operationDuration.isEnabled() || this.consumedEventCounter.isEnabled())) {
            String errorType = scope.getErrorType();
            TelemetryAttributes attributes = this.getOrCreateAttributes(OperationName.RECEIVE, partitionId, errorType);
            if (receivedCount > 0) {
                this.consumedEventCounter.add((long)receivedCount, errorType == null ? attributes : this.getOrCreateAttributes(OperationName.RECEIVE, partitionId, null), scope.getSpan());
            }
            this.operationDuration.record(InstrumentationUtils.getDurationInSeconds(scope.getStartTime()), attributes, scope.getSpan());
        }
    }

    public void reportLag(Instant enqueuedTime, String partitionId, InstrumentationScope scope) {
        if (this.isEnabled && this.consumerLag.isEnabled()) {
            this.consumerLag.record(InstrumentationUtils.getDurationInSeconds(enqueuedTime), this.lagAttributeCache.getOrCreate(partitionId), scope.getSpan());
        }
    }

    public void reportCheckpoint(Checkpoint checkpoint, InstrumentationScope scope) {
        if (this.isEnabled && this.operationDuration.isEnabled()) {
            this.operationDuration.record(InstrumentationUtils.getDurationInSeconds(scope.getStartTime()), this.getOrCreateAttributes(OperationName.CHECKPOINT, checkpoint.getPartitionId(), scope.getErrorType()), scope.getSpan());
        }
    }

    public void reportGenericOperationDuration(OperationName operationName, String partitionId, InstrumentationScope scope) {
        if (this.isEnabled && this.operationDuration.isEnabled()) {
            this.operationDuration.record(InstrumentationUtils.getDurationInSeconds(scope.getStartTime()), this.getOrCreateAttributes(operationName, partitionId, scope.getErrorType()), scope.getSpan());
        }
    }

    private TelemetryAttributes getOrCreateAttributes(OperationName operationName, String partitionId, String errorType) {
        if (errorType == null) {
            switch (operationName) {
                case SEND: {
                    return this.sendAttributeCacheSuccess.getOrCreate(partitionId);
                }
                case RECEIVE: {
                    return this.receiveAttributeCacheSuccess.getOrCreate(partitionId);
                }
                case CHECKPOINT: {
                    return this.checkpointAttributeCacheSuccess.getOrCreate(partitionId);
                }
                case PROCESS: {
                    return this.processAttributeCacheSuccess.getOrCreate(partitionId);
                }
                case GET_PARTITION_PROPERTIES: {
                    return this.getPartitionPropertiesAttributeCacheSuccess.getOrCreate(partitionId);
                }
                case GET_EVENT_HUB_PROPERTIES: {
                    return this.getEventHubPropertiesAttributeCacheSuccess.getOrCreate(partitionId);
                }
            }
            LOGGER.atVerbose().addKeyValue("operationName", (Object)operationName).log("Unknown operation name");
            return this.lagAttributeCache.getOrCreate(partitionId);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.commonAttributes);
        if (partitionId != null) {
            attributes.put("messaging.destination.partition.id", partitionId);
        }
        EventHubsMetricsProvider.setOperation(attributes, operationName);
        attributes.put("error.type", errorType);
        return this.meter.createAttributes(attributes);
    }

    private Map<String, Object> getCommonAttributes(String namespace, String entityName, String consumerGroup) {
        HashMap<String, String> commonAttributesMap = new HashMap<String, String>(4);
        commonAttributesMap.put("messaging.system", "eventhubs");
        commonAttributesMap.put("server.address", namespace);
        commonAttributesMap.put("messaging.destination.name", entityName);
        if (consumerGroup != null) {
            commonAttributesMap.put("messaging.consumer.group.name", consumerGroup);
        }
        return Collections.unmodifiableMap(commonAttributesMap);
    }

    private static void setOperation(Map<String, Object> attributes, OperationName name) {
        String operationType = InstrumentationUtils.getOperationType(name);
        if (operationType != null) {
            attributes.put("messaging.operation.type", operationType);
        }
        attributes.put("messaging.operation.name", name.toString());
    }

    private static final class AttributeCache {
        private final Map<String, TelemetryAttributes> attr = new ConcurrentHashMap<String, TelemetryAttributes>();
        private final TelemetryAttributes commonAttr;
        private final Map<String, Object> commonMap;
        private final String dimensionName;
        private final Meter meter;

        static AttributeCache create(Meter meter, OperationName operationName, Map<String, Object> commonAttributes) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(commonAttributes);
            EventHubsMetricsProvider.setOperation(attributes, operationName);
            return new AttributeCache(meter, "messaging.destination.partition.id", attributes);
        }

        private AttributeCache(Meter meter, String dimensionName, Map<String, Object> common) {
            this.dimensionName = dimensionName;
            this.commonMap = common;
            this.meter = meter;
            this.commonAttr = meter.createAttributes(this.commonMap);
        }

        public TelemetryAttributes getOrCreate(String value) {
            if (value == null) {
                return this.commonAttr;
            }
            return this.attr.computeIfAbsent(value, this::create);
        }

        private TelemetryAttributes create(String value) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(this.commonMap);
            attributes.put(this.dimensionName, value);
            return this.meter.createAttributes(attributes);
        }
    }
}

