/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.ListQueuesIncludeType;
import com.azure.storage.queue.implementation.models.ServicesGetPropertiesResponse;
import com.azure.storage.queue.implementation.models.ServicesGetStatisticsResponse;
import com.azure.storage.queue.implementation.models.ServicesListQueuesSegmentResponse;
import com.azure.storage.queue.implementation.models.ServicesSetPropertiesResponse;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private ServicesService service;
    private AzureQueueStorageImpl client;

    public ServicesImpl(AzureQueueStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(QueueServiceProperties properties, Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), properties, timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(QueueServiceProperties properties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.setProperties(this.client.getUrl(), properties, timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        return this.service.getProperties(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        String restype = "service";
        String comp = "stats";
        return this.service.getStatistics(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "stats", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        return this.service.getStatistics(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "service", "stats", context);
    }

    public Mono<ServicesListQueuesSegmentResponse> listQueuesSegmentWithRestResponseAsync(Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String comp = "list";
        String includeConverted = null;
        return this.service.listQueuesSegment(this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "list", context);
    }

    public Mono<ServicesListQueuesSegmentResponse> listQueuesSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, List<ListQueuesIncludeType> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listQueuesSegment(this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "list", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageServices")
    private static interface ServicesService {
        @Put(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ServicesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") QueueServiceProperties var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ServicesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ServicesGetStatisticsResponse> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ServicesListQueuesSegmentResponse> listQueuesSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, Context var10);
    }
}

