/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.util;

import com.azure.identity.extensions.implementation.enums.AuthProperty;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.service.implementation.identity.credential.provider.SpringTokenCredentialProvider;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SpringPasswordlessPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringPasswordlessPropertiesUtils.class);

    private SpringPasswordlessPropertiesUtils() {
    }

    public static void enhancePasswordlessProperties(String passwordlessPropertiesPrefix, PasswordlessProperties passwordlessProperties, Properties properties) {
        if (!passwordlessProperties.isPasswordlessEnabled()) {
            LOGGER.debug("Feature passwordless authentication is not enabled({}.passwordless-enabled=false), skip enhancing properties.", (Object)passwordlessPropertiesPrefix);
            return;
        }
        String tokenCredentialBeanName = passwordlessProperties.getCredential().getTokenCredentialBeanName();
        if (StringUtils.hasText((String)tokenCredentialBeanName)) {
            AuthProperty.TOKEN_CREDENTIAL_BEAN_NAME.setProperty(properties, tokenCredentialBeanName);
            AuthProperty.TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME.setProperty(properties, SpringTokenCredentialProvider.class.getName());
        }
    }

    public static void enhancePasswordlessProperties(String passwordlessPropertiesPrefix, PasswordlessProperties passwordlessProperties, Map<String, String> result) {
        Properties properties = passwordlessProperties.toPasswordlessProperties();
        result.forEach(properties::setProperty);
        SpringPasswordlessPropertiesUtils.enhancePasswordlessProperties(passwordlessPropertiesPrefix, passwordlessProperties, properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put((String)key, (String)value)));
    }
}

