/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.enums.StorageType;
import com.binarywang.spring.starter.wxjava.mp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.WxMpHostConfig;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

@Configuration
public class WxMpStorageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxMpStorageAutoConfiguration.class);
    private final ApplicationContext applicationContext;
    private final WxMpProperties wxMpProperties;

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorage.class})
    public WxMpConfigStorage wxMpConfigStorage() {
        WxMpConfigStorage config;
        StorageType type = this.wxMpProperties.getConfigStorage().getType();
        switch (type) {
            case Jedis: {
                config = this.jedisConfigStorage();
                break;
            }
            case RedisTemplate: {
                config = this.redisTemplateConfigStorage();
                break;
            }
            default: {
                config = this.defaultConfigStorage();
            }
        }
        if (null != this.wxMpProperties.getHosts() && StringUtils.isNotEmpty((CharSequence)this.wxMpProperties.getHosts().getApiHost())) {
            WxMpHostConfig hostConfig = new WxMpHostConfig();
            hostConfig.setApiHost(this.wxMpProperties.getHosts().getApiHost());
            hostConfig.setMpHost(this.wxMpProperties.getHosts().getMpHost());
            hostConfig.setOpenHost(this.wxMpProperties.getHosts().getOpenHost());
            config.setHostConfig(hostConfig);
        }
        return config;
    }

    private WxMpConfigStorage defaultConfigStorage() {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        this.setWxMpInfo(config);
        return config;
    }

    private WxMpConfigStorage jedisConfigStorage() {
        JedisPoolAbstract jedisPool = this.wxMpProperties.getConfigStorage() != null && this.wxMpProperties.getConfigStorage().getRedis() != null && StringUtils.isNotEmpty((CharSequence)this.wxMpProperties.getConfigStorage().getRedis().getHost()) ? this.getJedisPool() : (JedisPoolAbstract)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        WxMpRedisConfigImpl wxMpRedisConfig = new WxMpRedisConfigImpl((WxRedisOps)redisOps, this.wxMpProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxMpDefaultConfigImpl)wxMpRedisConfig);
        return wxMpRedisConfig;
    }

    private WxMpConfigStorage redisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = null;
        try {
            redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (null == redisTemplate) {
                redisTemplate = (StringRedisTemplate)this.applicationContext.getBean("stringRedisTemplate");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (null == redisTemplate) {
            redisTemplate = (StringRedisTemplate)this.applicationContext.getBean("redisTemplate");
        }
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        WxMpRedisConfigImpl wxMpRedisConfig = new WxMpRedisConfigImpl((WxRedisOps)redisOps, this.wxMpProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxMpDefaultConfigImpl)wxMpRedisConfig);
        return wxMpRedisConfig;
    }

    private void setWxMpInfo(WxMpDefaultConfigImpl config) {
        WxMpProperties properties = this.wxMpProperties;
        WxMpProperties.ConfigStorage configStorageProperties = properties.getConfigStorage();
        config.setAppId(properties.getAppId());
        config.setSecret(properties.getSecret());
        config.setToken(properties.getToken());
        config.setAesKey(properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
    }

    private JedisPoolAbstract getJedisPool() {
        RedisProperties redis = this.wxMpProperties.getConfigStorage().getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        if (StringUtils.isNotEmpty((CharSequence)redis.getSentinelIps())) {
            HashSet sentinels = Sets.newHashSet((Object[])redis.getSentinelIps().split(","));
            return new JedisSentinelPool(redis.getSentinelName(), (Set)sentinels);
        }
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMpStorageAutoConfiguration(ApplicationContext applicationContext, WxMpProperties wxMpProperties) {
        this.applicationContext = applicationContext;
        this.wxMpProperties = wxMpProperties;
    }
}

