/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AddTitleConsumer;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class AbstractReadHandler<T> {
    protected boolean isMapType;
    protected Map<Integer, Field> fieldMap;
    protected Class<T> dataType;
    protected Consumer<T> consumer;
    protected Function<T, Boolean> function;
    protected Predicate<Row> rowFilter;
    protected Predicate<T> beanFilter;
    protected List<T> result;
    protected T obj;
    protected Map<String, Integer> titles = new HashMap<String, Integer>();
    protected BiFunction<Throwable, ReadContext, Boolean> exceptionFunction;
    protected SaxExcelReader.ReadConfig<T> readConfig;
    protected AddTitleConsumer<String, Integer, Integer> addTitleConsumer = (v, rowNum, colNum) -> {};

    AbstractReadHandler() {
    }

    protected void init(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        this.result = result;
        this.dataType = readConfig.getDataType();
        this.fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        this.consumer = readConfig.getConsumer();
        this.function = readConfig.getFunction();
        this.rowFilter = readConfig.getRowFilter();
        this.beanFilter = readConfig.getBeanFilter();
        this.exceptionFunction = readConfig.getExceptionFunction();
        this.readConfig = readConfig;
        if (this.fieldMap.isEmpty()) {
            this.addTitleConsumer = this::addTitles;
        }
    }

    T newInstance(Class<T> clazz) {
        if (this.isMapType) {
            return (T)new LinkedHashMap();
        }
        if (clazz == Map.class) {
            this.isMapType = true;
            return (T)new LinkedHashMap();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initFieldMap(int rowNum) {
        if (rowNum != 0 || !this.fieldMap.isEmpty()) {
            return;
        }
        Map<String, Field> titleFieldMap = ReflectUtil.getFieldMapOfTitleExcelColumn(this.dataType);
        this.fieldMap = new HashMap<Integer, Field>(titleFieldMap.size());
        this.titles.forEach((k, v) -> this.fieldMap.put((Integer)v, (Field)titleFieldMap.get(k)));
    }

    private void addTitles(String formattedValue, int rowNum, int thisCol) {
        if (rowNum == 0) {
            this.titles.put(formattedValue, thisCol);
        }
    }
}

