/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcelTable;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.constant.BooleanDropDownList;
import com.github.liaochong.myexcel.core.constant.DropDownList;
import com.github.liaochong.myexcel.core.constant.File;
import com.github.liaochong.myexcel.core.constant.ImageFile;
import com.github.liaochong.myexcel.core.constant.LinkEmail;
import com.github.liaochong.myexcel.core.constant.LinkUrl;
import com.github.liaochong.myexcel.core.constant.NumberDropDownList;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.StyleUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class AbstractSimpleExcelBuilder {
    protected List<String> fieldDisplayOrder;
    protected WorkbookType workbookType;
    protected Map<String, String> commonTdStyle;
    protected Map<String, String> evenTdStyle;
    protected Map<String, String> linkCommonStyle;
    protected Map<String, String> linkEvenStyle;
    protected List<String> titles;
    protected String sheetName;
    protected String globalDefaultValue;
    protected Map<Field, String> defaultValueMap;
    protected Map<Integer, Integer> customWidthMap;
    protected boolean wrapText = true;
    protected int titleLevel = 0;
    protected String titleSeparator = "->";
    protected Map<String, Map<String, String>> customStyle = new HashMap<String, Map<String, String>>();
    protected boolean isOddRow = true;
    protected int rowHeight;
    protected int titleRowHeight;
    protected boolean noStyle;
    protected WidthStrategy widthStrategy;
    protected Map<Integer, Integer> widths;
    private Map<Integer, String> formats = new HashMap<Integer, String>();
    private Map<String, Map<String, String>> formatsStyleMap;

    AbstractSimpleExcelBuilder() {
    }

    protected Table createTable() {
        Table table = new Table();
        table.setCaption(this.sheetName);
        table.setTrList(new LinkedList<Tr>());
        return table;
    }

    protected List<Tr> createThead() {
        if (this.titles == null || this.titles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tdLists = new ArrayList();
        for (int i = 0; i < this.titles.size(); ++i) {
            String string = this.titles.get(i);
            if (string == null) continue;
            ArrayList<Td> tds = new ArrayList<Td>();
            String[] multiTitles = string.split(this.titleSeparator);
            if (multiTitles.length > this.titleLevel) {
                this.titleLevel = multiTitles.length;
            }
            for (int j = 0; j < multiTitles.length; ++j) {
                Td td2 = new Td(j, i);
                td2.setTh(true);
                td2.setContent(multiTitles[j]);
                tds.add(td2);
            }
            tdLists.add(tds);
        }
        for (List list2 : tdLists) {
            Td last = (Td)list2.get(list2.size() - 1);
            last.setRowSpan(this.titleLevel - last.getRow());
        }
        int i = 0;
        while (i < this.titleLevel) {
            int n = i++;
            Map<String, List<List>> groups = tdLists.stream().filter(list -> list.size() > level).collect(Collectors.groupingBy(list -> ((Td)list.get(level)).getContent()));
            groups.forEach((k, v) -> {
                if (v.size() == 1) {
                    return;
                }
                List tds = v.stream().map(list -> (Td)list.get(level)).sorted(Comparator.comparing(Td::getCol)).collect(Collectors.toList());
                LinkedList subTds = new LinkedList();
                Map<Integer, List<Td>> partitions = tds.stream().collect(Collectors.groupingBy(Td::getRowSpan));
                partitions.forEach((col, subTdList) -> {
                    int splitIndex = 0;
                    int size = subTdList.size() - 1;
                    for (int j = 0; j < size; ++j) {
                        Td current = (Td)subTdList.get(j);
                        Td next = (Td)subTdList.get(j + 1);
                        if (current.getCol() + 1 == next.getCol()) continue;
                        List sub = subTdList.subList(splitIndex, j + 1);
                        splitIndex = j + 1;
                        if (sub.size() <= 1) continue;
                        subTds.add(sub);
                    }
                    subTds.add(subTdList.subList(splitIndex, subTdList.size()));
                });
                subTds.forEach(val -> {
                    if (val.size() == 1) {
                        return;
                    }
                    Td t = (Td)val.get(0);
                    t.setColSpan(val.size());
                    for (int j = 1; j < val.size(); ++j) {
                        ((Td)val.get(j)).setRow(-1);
                    }
                });
            });
        }
        Map<String, String> thStyle = this.getDefaultThStyle();
        Map<Integer, List<Td>> map = tdLists.stream().flatMap(Collection::stream).filter(td -> td.getRow() > -1).collect(Collectors.groupingBy(Td::getRow));
        ArrayList<Tr> trs = new ArrayList<Tr>();
        boolean isComputeAutoWidth = WidthStrategy.isComputeAutoWidth(this.widthStrategy);
        map.forEach((k, v) -> {
            Tr tr = new Tr((int)k, this.titleRowHeight);
            tr.setColWidthMap(isComputeAutoWidth ? new HashMap(this.titles.size()) : Collections.emptyMap());
            List<Td> tds = v.stream().sorted(Comparator.comparing(Td::getCol)).peek(td -> {
                if (!this.noStyle && !this.customStyle.isEmpty()) {
                    Map<String, String> style = this.customStyle.getOrDefault("title&" + td.getCol(), Collections.emptyMap());
                    td.setStyle(style);
                } else {
                    td.setStyle(thStyle);
                }
                if (isComputeAutoWidth) {
                    tr.getColWidthMap().put(td.getCol(), TdUtil.getStringWidth(td.getContent(), 0.25));
                }
            }).collect(Collectors.toList());
            tr.setTdList(tds);
            trs.add(tr);
        });
        return trs;
    }

    private Map<String, String> getDefaultThStyle() {
        Map<String, String> thStyle;
        if (this.noStyle) {
            thStyle = Collections.emptyMap();
        } else {
            thStyle = new HashMap<String, String>(7);
            thStyle.put("font-weight", "bold");
            thStyle.put("font-size", "14");
            thStyle.put("text-align", "center");
            thStyle.put("vertical-align", "middle");
            thStyle.put("border-bottom-style", "thin");
            thStyle.put("border-left-style", "thin");
            thStyle.put("border-right-style", "thin");
        }
        return thStyle;
    }

    protected Tr createTr(List<Pair<? extends Class, ?>> contents) {
        boolean isComputeAutoWidth = WidthStrategy.isComputeAutoWidth(this.widthStrategy);
        boolean isCustomWidth = WidthStrategy.isCustomWidth(this.widthStrategy);
        Tr tr = new Tr(0, this.rowHeight);
        tr.setColWidthMap(isComputeAutoWidth || isCustomWidth ? new HashMap(contents.size()) : Collections.emptyMap());
        Map<String, String> tdStyle = this.isOddRow ? this.commonTdStyle : this.evenTdStyle;
        Map<String, String> linkStyle = this.isOddRow ? this.linkCommonStyle : this.linkEvenStyle;
        String oddEvenPrefix = this.isOddRow ? "odd&" : "even&";
        this.isOddRow = !this.isOddRow;
        List<Td> tdList = IntStream.range(0, contents.size()).mapToObj(i -> {
            Map<String, String> style;
            Td td = new Td(0, i);
            Pair pair = (Pair)contents.get(i);
            Class fieldType = (Class)pair.getKey();
            if (File.class.isAssignableFrom(fieldType)) {
                td.setFile(pair.getValue() == null ? null : (java.io.File)pair.getValue());
            } else {
                td.setContent(pair.getValue() == null ? null : String.valueOf(pair.getValue()));
            }
            this.setTdContentType(td, fieldType);
            if (!this.noStyle && !this.customStyle.isEmpty()) {
                style = this.customStyle.get(oddEvenPrefix + i);
                if (style == null) {
                    style = this.customStyle.getOrDefault("cell&" + i, Collections.emptyMap());
                }
            } else {
                Map<String, String> map = style = ContentTypeEnum.isLink(td.getTdContentType()) ? linkStyle : tdStyle;
            }
            if (isComputeAutoWidth) {
                tr.getColWidthMap().put(i, TdUtil.getStringWidth(td.getContent()));
            }
            if (this.formats.get(i) != null) {
                String format = this.formats.get(i);
                Map<String, String> formatStyle = this.formatsStyleMap.get(format + "_" + i + "_" + oddEvenPrefix);
                if (formatStyle == null) {
                    formatStyle = new HashMap<String, String>(style);
                    formatStyle.put("format", format);
                    this.formatsStyleMap.put(format + "_" + i, formatStyle);
                }
                style = formatStyle;
            }
            td.setStyle(style);
            return td;
        }).collect(Collectors.toList());
        if (isCustomWidth) {
            tr.setColWidthMap(this.customWidthMap);
        }
        tr.setTdList(tdList);
        return tr;
    }

    private void setTdContentType(Td td, Class fieldType) {
        if (String.class == fieldType) {
            return;
        }
        if (ReflectUtil.isNumber(fieldType)) {
            td.setTdContentType(ContentTypeEnum.DOUBLE);
            return;
        }
        if (ReflectUtil.isBool(fieldType)) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN);
            return;
        }
        if (fieldType == DropDownList.class) {
            td.setTdContentType(ContentTypeEnum.DROP_DOWN_LIST);
            return;
        }
        if (fieldType == NumberDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.NUMBER_DROP_DOWN_LIST);
            return;
        }
        if (fieldType == BooleanDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN_DROP_DOWN_LIST);
            return;
        }
        if (td.getContent() != null && fieldType == LinkUrl.class) {
            td.setTdContentType(ContentTypeEnum.LINK_URL);
            this.setLinkTd(td);
            return;
        }
        if (td.getContent() != null && fieldType == LinkEmail.class) {
            td.setTdContentType(ContentTypeEnum.LINK_EMAIL);
            this.setLinkTd(td);
            return;
        }
        if (td.getFile() != null && fieldType == ImageFile.class) {
            td.setTdContentType(ContentTypeEnum.IMAGE);
        }
    }

    private void setLinkTd(Td td) {
        String[] splits = td.getContent().split("->");
        if (splits.length == 1) {
            td.setLink(td.getContent());
        } else {
            td.setContent(splits[0]);
            td.setLink(splits[1]);
        }
    }

    protected List<Field> getFilteredFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ExcelTable excelTable = classFieldContainer.getClazz().getAnnotation(ExcelTable.class);
        boolean excelTableExist = Objects.nonNull(excelTable);
        boolean excludeParent = false;
        boolean includeAllField = false;
        boolean ignoreStaticFields = true;
        String[] globalStyle = null;
        if (excelTableExist) {
            this.setWorkbookWithExcelTableAnnotation(excelTable);
            excludeParent = excelTable.excludeParent();
            includeAllField = excelTable.includeAllField();
            if (!excelTable.defaultValue().isEmpty()) {
                this.globalDefaultValue = excelTable.defaultValue();
            }
            this.wrapText = excelTable.wrapText();
            this.titleSeparator = excelTable.titleSeparator();
            ignoreStaticFields = excelTable.ignoreStaticFields();
            this.titleRowHeight = excelTable.titleRowHeight();
            this.rowHeight = excelTable.rowHeight();
            globalStyle = excelTable.style();
        }
        List<Field> preElectionFields = this.getPreElectionFields(classFieldContainer, excludeParent, includeAllField);
        if (ignoreStaticFields) {
            preElectionFields = preElectionFields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        }
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        List<Field> sortedFields = preElectionFields.stream().filter(field -> !field.isAnnotationPresent(ExcludeColumn.class) && ReflectUtil.isFieldSelected(selectedGroupList, field)).sorted(ReflectUtil::sortFields).collect(Collectors.toList());
        this.defaultValueMap = new HashMap<Field, String>(sortedFields.size());
        if (this.customWidthMap == null) {
            this.customWidthMap = new HashMap<Integer, Integer>(sortedFields.size());
        }
        this.formats = new HashMap<Integer, String>(sortedFields.size());
        this.formatsStyleMap = new HashMap<String, Map<String, String>>();
        ArrayList<String> titles = new ArrayList<String>(sortedFields.size());
        boolean useFieldNameAsTitle = excelTableExist && excelTable.useFieldNameAsTitle();
        boolean needToAddTitle = Objects.isNull(this.titles);
        Map<String, String> globalStyleMap = this.getGlobalStyleMap(globalStyle);
        this.setOddEvenStyle(globalStyleMap);
        int size = sortedFields.size();
        for (int i = 0; i < size; ++i) {
            Field field2 = (Field)sortedFields.get(i);
            ExcelColumn excelColumn = field2.getAnnotation(ExcelColumn.class);
            this.setCustomStyle(i, globalStyleMap.get("cell"));
            this.setCustomStyle(i, globalStyleMap.get("title"));
            if (excelColumn != null) {
                if (needToAddTitle) {
                    if (useFieldNameAsTitle && excelColumn.title().isEmpty()) {
                        titles.add(field2.getName());
                    } else {
                        titles.add(excelColumn.title());
                    }
                }
                if (!excelColumn.defaultValue().isEmpty()) {
                    this.defaultValueMap.put(field2, excelColumn.defaultValue());
                }
                if (this.widths == null && excelColumn.width() > 0) {
                    this.customWidthMap.put(i, excelColumn.width());
                }
                if (!this.noStyle && excelColumn.style().length > 0) {
                    this.setCustomStyle(i, excelColumn.style());
                }
                if (!StringUtil.isNotBlank(excelColumn.decimalFormat())) continue;
                this.formats.put(i, excelColumn.decimalFormat());
                continue;
            }
            if (!needToAddTitle) continue;
            if (useFieldNameAsTitle) {
                titles.add(field2.getName());
                continue;
            }
            titles.add(null);
        }
        boolean hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank);
        if (hasTitle) {
            this.titles = titles;
        }
        if (!this.customWidthMap.isEmpty()) {
            this.widthStrategy = WidthStrategy.CUSTOM_WIDTH;
        }
        return sortedFields;
    }

    private Map<String, String> getGlobalStyleMap(String[] globalStyle) {
        HashMap<String, String> globalStyleMap = new HashMap<String, String>();
        if (globalStyle != null) {
            Arrays.stream(globalStyle).forEach(style -> {
                String[] splits = style.split("->");
                if (splits.length == 1) {
                    globalStyleMap.put("cell", (String)style);
                } else {
                    globalStyleMap.put(splits[0], (String)style);
                }
            });
        }
        return globalStyleMap;
    }

    private void setOddEvenStyle(Map<String, String> globalStyleMap) {
        String evenStyle;
        String oddStyle = globalStyleMap.get("odd");
        if (oddStyle != null) {
            this.commonTdStyle = StyleUtil.parseStyle(oddStyle.split("->")[1]);
        }
        if ((evenStyle = globalStyleMap.get("even")) != null) {
            this.evenTdStyle = StyleUtil.parseStyle(evenStyle.split("->")[1]);
        }
    }

    private void setCustomStyle(int i, String ... styles) {
        for (String style : styles) {
            Map<String, String> styleMap;
            if (StringUtil.isBlank(style)) continue;
            if (StringUtil.isBlank(style)) {
                throw new IllegalArgumentException("Illegal style");
            }
            String[] splits = style.split("->");
            if (splits.length == 1) {
                styleMap = this.setWidthStrategyAndWidth(splits, 0, i);
                this.customStyle.put("cell&" + i, styleMap);
                break;
            }
            styleMap = this.setWidthStrategyAndWidth(splits, 1, i);
            this.customStyle.put(splits[0] + "&" + i, styleMap);
        }
    }

    private Map<String, String> setWidthStrategyAndWidth(String[] splits, int splitIndex, int fieldIndex) {
        Map<String, String> styleMap = StyleUtil.parseStyle(splits[splitIndex]);
        String width = styleMap.get("width");
        if (width != null) {
            this.widthStrategy = WidthStrategy.CUSTOM_WIDTH;
            this.customWidthMap.put(fieldIndex, TdUtil.getValue(width));
        }
        return styleMap;
    }

    private List<Field> getPreElectionFields(ClassFieldContainer classFieldContainer, boolean excludeParent, boolean includeAllField) {
        if (Objects.nonNull(this.fieldDisplayOrder) && !this.fieldDisplayOrder.isEmpty()) {
            this.selfAdaption();
            return this.fieldDisplayOrder.stream().map(classFieldContainer::getFieldByName).collect(Collectors.toList());
        }
        if (includeAllField) {
            List<Field> preElectionFields = excludeParent ? classFieldContainer.getDeclaredFields() : classFieldContainer.getFields();
            return preElectionFields;
        }
        List<Field> preElectionFields = excludeParent ? classFieldContainer.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(ExcelColumn.class)).collect(Collectors.toList()) : classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        return preElectionFields;
    }

    private void setWorkbookWithExcelTableAnnotation(ExcelTable excelTable) {
        String sheetName;
        if (this.workbookType == null) {
            this.workbookType = excelTable.workbookType();
        }
        if (StringUtil.isBlank(this.sheetName) && StringUtil.isNotBlank(sheetName = excelTable.sheetName())) {
            this.sheetName = sheetName;
        }
    }

    private void selfAdaption() {
        if (this.titles == null || this.titles.isEmpty()) {
            return;
        }
        if (this.fieldDisplayOrder.size() > this.titles.size()) {
            int size = this.fieldDisplayOrder.size() - this.titles.size();
            for (int i = 0; i < size; ++i) {
                this.titles.add(null);
            }
        }
    }

    protected <T> List<Pair<? extends Class, ?>> getRenderContent(T data, List<Field> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(field.getType(), defaultValue);
            }
            if (this.globalDefaultValue != null) {
                return Pair.of(field.getType(), this.globalDefaultValue);
            }
            return value;
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    protected void initStyleMap() {
        if (this.noStyle) {
            this.linkEvenStyle = Collections.emptyMap();
            this.linkCommonStyle = this.linkEvenStyle;
            this.evenTdStyle = this.linkEvenStyle;
            this.commonTdStyle = this.linkEvenStyle;
        } else {
            if (this.commonTdStyle == null) {
                this.commonTdStyle = new HashMap<String, String>(3);
                this.commonTdStyle.put("border-bottom-style", "thin");
                this.commonTdStyle.put("border-left-style", "thin");
                this.commonTdStyle.put("border-right-style", "thin");
                this.commonTdStyle.put("vertical-align", "middle");
                if (this.wrapText) {
                    this.commonTdStyle.put("word-break", "break-all");
                }
            }
            if (this.evenTdStyle == null) {
                this.evenTdStyle = new HashMap<String, String>(4);
                this.evenTdStyle.put("background-color", "#f6f8fa");
                this.evenTdStyle.putAll(this.commonTdStyle);
            }
            this.linkCommonStyle = new HashMap<String, String>(this.commonTdStyle);
            this.linkCommonStyle.put("color", "blue");
            this.linkCommonStyle.put("text-decoration", "underline");
            this.linkEvenStyle = new HashMap<String, String>(this.linkCommonStyle);
            this.linkEvenStyle.putAll(this.evenTdStyle);
        }
    }
}

