/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelBuilder;
import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;

public class BeetlExcelBuilder
extends AbstractExcelBuilder {
    private static final GroupTemplate GROUP_TEMPLATE;
    private Template template;

    public BeetlExcelBuilder() {
        this.widthStrategy(WidthStrategy.AUTO_WIDTH);
    }

    @Override
    public ExcelBuilder template(String path) {
        this.template = GROUP_TEMPLATE.getTemplate(path);
        return this;
    }

    @Override
    protected <T> void render(Map<String, T> data, Writer out) {
        Objects.requireNonNull(this.template, "The template cannot be empty. Please set the template first.");
        this.template.binding(data);
        this.template.renderTo(out);
    }

    static {
        Configuration cfg;
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cfg.setCharset("UTF-8");
        GROUP_TEMPLATE = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
    }
}

