/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class Csv {
    private Path filePath;

    Csv(Path filePath) {
        this.filePath = filePath;
        byte[] bom = new byte[]{-17, -69, -65};
        try {
            Files.write(this.filePath, bom, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void write(Path target) {
        this.write(target, false);
    }

    public void write(Path target, boolean append) {
        Path origin = this.filePath;
        try {
            if (!Files.exists(target, new LinkOption[0])) {
                Files.write(target, Files.readAllBytes(origin), new OpenOption[0]);
                return;
            }
            if (append) {
                Files.write(target, Files.readAllBytes(origin), StandardOpenOption.APPEND);
            } else {
                Files.write(target, Files.readAllBytes(origin), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        TempFileOperator.deleteTempFile(this.filePath);
    }
}

