/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Csv;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcelTable;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.container.ParallelContainer;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.CsvBuildException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CsvBuilder<T>
implements Closeable {
    private static final Pattern PATTERN_QUOTES_PREMISE = Pattern.compile("[,\"]+");
    private static final Pattern PATTERN_QUOTES = Pattern.compile("\"");
    private String globalDefaultValue;
    private Map<Field, String> defaultValueMap;
    private List<String> titles;
    private List<Field> fields;
    private Csv csv;

    private CsvBuilder() {
    }

    public static <T> CsvBuilder<T> of(Class<T> clazz) {
        CsvBuilder<T> csvBuilder = new CsvBuilder<T>();
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(clazz);
        csvBuilder.fields = super.getFields(classFieldContainer, new Class[0]);
        Path csvTemp = TempFileOperator.createTempFile("d_t_c", ".csv");
        csvBuilder.csv = new Csv(csvTemp);
        return csvBuilder;
    }

    public CsvBuilder<T> groups(Class<?> ... groups) {
        this.fields = this.getGroupFields(this.fields, groups);
        return this;
    }

    public CsvBuilder<T> noTitles() {
        this.titles = null;
        return this;
    }

    public Csv build(List<T> beans) {
        return this.build(beans, this.csv);
    }

    public void append(List<T> beans) {
        this.build(beans, this.csv);
    }

    public Csv build() {
        return this.csv;
    }

    private Csv build(List<T> beans, Csv csv) {
        try {
            if (beans == null || beans.isEmpty()) {
                return csv;
            }
            List<List<?>> contents = this.getRenderContent((T)beans, this.fields);
            this.writeToCsv(contents, csv);
        }
        catch (Exception e) {
            TempFileOperator.deleteTempFile(csv.getFilePath());
            throw new CsvBuildException("Build csv failure", e);
        }
        return csv;
    }

    private List<Field> getFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ExcelTable excelTable = classFieldContainer.getClazz().getAnnotation(ExcelTable.class);
        boolean excelTableExist = Objects.nonNull(excelTable);
        boolean excludeParent = false;
        boolean includeAllField = false;
        boolean ignoreStaticFields = true;
        if (excelTableExist) {
            excludeParent = excelTable.excludeParent();
            includeAllField = excelTable.includeAllField();
            if (!excelTable.defaultValue().isEmpty()) {
                this.globalDefaultValue = excelTable.defaultValue();
            }
            ignoreStaticFields = excelTable.ignoreStaticFields();
        }
        List<Field> preElectionFields = this.getPreElectionFields(classFieldContainer, excludeParent, includeAllField);
        if (ignoreStaticFields) {
            preElectionFields = preElectionFields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        }
        boolean useFieldNameAsTitle = excelTableExist && excelTable.useFieldNameAsTitle();
        List<Field> sortedFields = this.getGroupFields(preElectionFields, groups);
        ArrayList<String> titles = new ArrayList<String>(preElectionFields.size());
        this.defaultValueMap = new HashMap<Field, String>(preElectionFields.size());
        boolean needToAddTitle = this.titles == null;
        for (Field field2 : sortedFields) {
            ExcelColumn excelColumn = field2.getAnnotation(ExcelColumn.class);
            if (excelColumn != null) {
                if (needToAddTitle) {
                    if (useFieldNameAsTitle && excelColumn.title().isEmpty()) {
                        titles.add(field2.getName());
                    } else {
                        titles.add(excelColumn.title());
                    }
                }
                if (excelColumn.defaultValue().isEmpty()) continue;
                this.defaultValueMap.put(field2, excelColumn.defaultValue());
                continue;
            }
            if (!needToAddTitle) continue;
            if (useFieldNameAsTitle) {
                titles.add(field2.getName());
                continue;
            }
            titles.add(null);
        }
        boolean hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank);
        if (hasTitle) {
            this.titles = titles;
        }
        return sortedFields;
    }

    private List<Field> getGroupFields(List<Field> preElectionFields, Class<?>[] groups) {
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        return preElectionFields.stream().filter(field -> !field.isAnnotationPresent(ExcludeColumn.class) && ReflectUtil.isFieldSelected(selectedGroupList, field)).sorted(ReflectUtil::sortFields).collect(Collectors.toList());
    }

    private List<Field> getPreElectionFields(ClassFieldContainer classFieldContainer, boolean excludeParent, boolean includeAllField) {
        if (includeAllField) {
            if (excludeParent) {
                return classFieldContainer.getDeclaredFields();
            }
            return classFieldContainer.getFields();
        }
        if (excludeParent) {
            return classFieldContainer.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(ExcelColumn.class)).collect(Collectors.toList());
        }
        return classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
    }

    private List<List<?>> getRenderContent(List<T> data, List<Field> sortedFields) {
        List resolvedDataContainers = IntStream.range(0, data.size()).parallel().mapToObj(index -> {
            List<?> resolvedDataList = this.getRenderContent(data.get(index), sortedFields);
            return new ParallelContainer(index, resolvedDataList);
        }).collect(Collectors.toCollection(LinkedList::new));
        data.clear();
        return resolvedDataContainers.stream().sorted(Comparator.comparing(ParallelContainer::getIndex)).map(ParallelContainer::getData).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<?> getRenderContent(T data, List<Field> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(field.getType(), defaultValue);
            }
            if (this.globalDefaultValue != null) {
                return Pair.of(field.getType(), this.globalDefaultValue);
            }
            return value;
        }).map(Pair::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    private void writeToCsv(List<List<?>> data, Csv csv) {
        if (this.titles != null) {
            data.add(0, this.titles);
            this.titles = null;
        }
        List content = data.stream().map(d -> d.stream().map(v -> {
            if (v == null) {
                return "";
            }
            String vStr = v.toString();
            vStr = PATTERN_QUOTES.matcher(vStr).replaceAll("\"\"");
            boolean hasComma = PATTERN_QUOTES_PREMISE.matcher(v.toString()).find();
            if (hasComma) {
                vStr = "\"" + vStr + "\"";
            }
            return vStr;
        }).collect(Collectors.joining(","))).collect(Collectors.toCollection(LinkedList::new));
        try {
            Files.write(csv.getFilePath(), (Iterable<? extends CharSequence>)content, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }

    public void clear() {
        if (this.csv != null) {
            this.csv.clear();
        }
    }
}

