/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.DefaultStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelBuilder
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelBuilder.class);
    private DefaultStreamExcelBuilder streamExcelBuilder;

    private DefaultExcelBuilder(DefaultStreamExcelBuilder streamExcelBuilder) {
        streamExcelBuilder.hasStyle();
        streamExcelBuilder.widthStrategy(WidthStrategy.COMPUTE_AUTO_WIDTH);
        this.streamExcelBuilder = streamExcelBuilder;
    }

    public static DefaultExcelBuilder getInstance() {
        DefaultExcelBuilder defaultExcelBuilder = new DefaultExcelBuilder(DefaultStreamExcelBuilder.getInstance());
        defaultExcelBuilder.streamExcelBuilder.workbookType(WorkbookType.XLSX);
        return defaultExcelBuilder;
    }

    public static DefaultExcelBuilder getInstance(Workbook workbook) {
        return new DefaultExcelBuilder(DefaultStreamExcelBuilder.getInstance(workbook));
    }

    public static DefaultExcelBuilder of(@NonNull Class<?> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DefaultExcelBuilder defaultExcelBuilder = new DefaultExcelBuilder(DefaultStreamExcelBuilder.of(dataType));
        defaultExcelBuilder.streamExcelBuilder.workbookType(WorkbookType.XLSX);
        return defaultExcelBuilder;
    }

    public static DefaultExcelBuilder of(@NonNull Class<?> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        return new DefaultExcelBuilder(DefaultStreamExcelBuilder.of(dataType, workbook));
    }

    public DefaultExcelBuilder titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.streamExcelBuilder.titles(titles);
        return this;
    }

    public DefaultExcelBuilder sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.streamExcelBuilder.sheetName(sheetName);
        return this;
    }

    public DefaultExcelBuilder fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.streamExcelBuilder.fieldDisplayOrder(fieldDisplayOrder);
        return this;
    }

    public DefaultExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        this.streamExcelBuilder.workbookType(workbookType);
        return this;
    }

    public DefaultExcelBuilder noStyle() {
        this.streamExcelBuilder.noStyle();
        return this;
    }

    public DefaultExcelBuilder widthStrategy(WidthStrategy widthStrategy) {
        this.streamExcelBuilder.widthStrategy(widthStrategy);
        return this;
    }

    @Deprecated
    public DefaultExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.streamExcelBuilder.autoWidthStrategy(autoWidthStrategy);
        return this;
    }

    public DefaultExcelBuilder fixedTitles() {
        this.streamExcelBuilder.fixedTitles();
        return this;
    }

    public DefaultExcelBuilder widths(int ... widths) {
        this.streamExcelBuilder.widths(widths);
        return this;
    }

    public DefaultExcelBuilder groups(Class<?> ... groups) {
        this.streamExcelBuilder.groups((Class[])groups);
        return this;
    }

    public Workbook build(List<?> data) {
        try {
            this.streamExcelBuilder.start();
            this.streamExcelBuilder.append(data);
            return this.streamExcelBuilder.build();
        }
        catch (Exception e) {
            try {
                this.streamExcelBuilder.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.streamExcelBuilder != null) {
            this.streamExcelBuilder.close();
        }
    }
}

