/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelReader<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelReader.class);
    private static final int DEFAULT_SHEET_INDEX = 0;
    private Class<T> dataType;
    private int sheetIndex = 0;
    private Predicate<Row> rowFilter = row -> true;
    private Predicate<T> beanFilter = bean -> true;
    private Workbook wb;
    private BiFunction<Throwable, ReadContext, Boolean> exceptionFunction = (e, c) -> false;

    private DefaultExcelReader(Class<T> dataType) {
        this.dataType = dataType;
    }

    public static <T> DefaultExcelReader<T> of(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return new DefaultExcelReader<T>(clazz);
    }

    public DefaultExcelReader<T> sheet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Sheet index must be greater than or equal to 0");
        }
        this.sheetIndex = index;
        return this;
    }

    public DefaultExcelReader<T> rowFilter(@NonNull Predicate<Row> rowFilter) {
        if (rowFilter == null) {
            throw new NullPointerException("rowFilter is marked non-null but is null");
        }
        this.rowFilter = rowFilter;
        return this;
    }

    public DefaultExcelReader<T> beanFilter(@NonNull Predicate<T> beanFilter) {
        if (beanFilter == null) {
            throw new NullPointerException("beanFilter is marked non-null but is null");
        }
        this.beanFilter = beanFilter;
        return this;
    }

    public DefaultExcelReader<T> exceptionally(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        this.exceptionFunction = exceptionFunction;
        return this;
    }

    public List<T> read(@NonNull InputStream fileInputStream) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        return this.read(fileInputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> read(@NonNull InputStream fileInputStream, String password) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Sheet sheet = this.getSheetOfInputStream(fileInputStream, password);
            List<T> list = this.getDataFromFile(sheet, fieldMap);
            return list;
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    public List<T> read(@NonNull File file) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.read(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> read(@NonNull File file, String password) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.getName().endsWith(".xlsx") && !file.getName().endsWith(".xls")) {
            throw new IllegalArgumentException("Support only. xls and. xlsx suffix files");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Sheet sheet = this.getSheetOfFile(file, password);
            List<T> list = this.getDataFromFile(sheet, fieldMap);
            return list;
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    public void readThen(@NonNull InputStream fileInputStream, Consumer<T> consumer) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        this.readThen(fileInputStream, null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readThen(@NonNull InputStream fileInputStream, String password, Consumer<T> consumer) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return;
        }
        try {
            Sheet sheet = this.getSheetOfInputStream(fileInputStream, password);
            this.readThenConsume(sheet, fieldMap, consumer, null);
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    public void readThen(@NonNull File file, Consumer<T> consumer) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.readThen(file, null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readThen(@NonNull File file, String password, Consumer<T> consumer) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.getName().endsWith(".xlsx") && !file.getName().endsWith(".xls")) {
            throw new IllegalArgumentException("Support only. xls and. xlsx suffix files");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return;
        }
        try {
            Sheet sheet = this.getSheetOfFile(file, password);
            this.readThenConsume(sheet, fieldMap, consumer, null);
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    public void readThen(@NonNull InputStream fileInputStream, Function<T, Boolean> function) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        this.readThen(fileInputStream, null, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readThen(@NonNull InputStream fileInputStream, String password, Function<T, Boolean> function) throws Exception {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return;
        }
        try {
            Sheet sheet = this.getSheetOfInputStream(fileInputStream, password);
            this.readThenConsume(sheet, fieldMap, null, function);
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    public void readThen(@NonNull File file, Function<T, Boolean> function) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.readThen(file, null, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readThen(@NonNull File file, String password, Function<T, Boolean> function) throws Exception {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.getName().endsWith(".xlsx") && !file.getName().endsWith(".xls")) {
            throw new IllegalArgumentException("Support only. xls and. xlsx suffix files");
        }
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        if (fieldMap.isEmpty()) {
            return;
        }
        try {
            Sheet sheet = this.getSheetOfFile(file, password);
            this.readThenConsume(sheet, fieldMap, null, function);
        }
        finally {
            if (Objects.nonNull(this.wb)) {
                this.wb.close();
            }
        }
    }

    private Sheet getSheetOfInputStream(@NonNull InputStream fileInputStream, String password) throws IOException {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        this.wb = StringUtil.isBlank(password) ? WorkbookFactory.create((InputStream)fileInputStream) : WorkbookFactory.create((InputStream)fileInputStream, (String)password);
        return this.wb.getSheetAt(this.sheetIndex);
    }

    private Sheet getSheetOfFile(@NonNull File file, String password) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.wb = StringUtil.isBlank(password) ? WorkbookFactory.create((File)file) : WorkbookFactory.create((File)file, (String)password);
        return this.wb.getSheetAt(this.sheetIndex);
    }

    private List<T> getDataFromFile(Sheet sheet, Map<Integer, Field> fieldMap) {
        long startTime = System.currentTimeMillis();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        log.info("FirstRowNum:{},LastRowNum:{}", (Object)firstRowNum, (Object)lastRowNum);
        if (lastRowNum < 0) {
            log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
            return Collections.emptyList();
        }
        DataFormatter formatter = new DataFormatter();
        LinkedList<T> result = new LinkedList<T>();
        for (int i = firstRowNum; i <= lastRowNum; ++i) {
            T obj;
            Row row = sheet.getRow(i);
            if (Objects.isNull(row)) {
                log.info("Row of {} is null,it will be ignored.", (Object)i);
                continue;
            }
            boolean noMatchResult = this.rowFilter.negate().test(row);
            if (noMatchResult) {
                log.info("Row of {} does not meet the filtering criteria, it will be ignored.", (Object)i);
                continue;
            }
            short lastColNum = row.getLastCellNum();
            if (lastColNum < 0 || !this.beanFilter.test(obj = this.instanceObj(fieldMap, formatter, row))) continue;
            result.add(obj);
        }
        log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void readThenConsume(Sheet sheet, Map<Integer, Field> fieldMap, Consumer<T> consumer, Function<T, Boolean> function) {
        long startTime = System.currentTimeMillis();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        log.info("FirstRowNum:{},LastRowNum:{}", (Object)firstRowNum, (Object)lastRowNum);
        if (lastRowNum < 0) {
            log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
            return;
        }
        DataFormatter formatter = new DataFormatter();
        for (int i = firstRowNum; i <= lastRowNum; ++i) {
            Boolean noStop;
            T obj;
            Row row = sheet.getRow(i);
            if (Objects.isNull(row)) {
                log.info("Row of {} is null,it will be ignored.", (Object)i);
                continue;
            }
            boolean noMatchResult = this.rowFilter.negate().test(row);
            if (noMatchResult) {
                log.info("Row of {} does not meet the filtering criteria, it will be ignored.", (Object)i);
                continue;
            }
            short lastColNum = row.getLastCellNum();
            if (lastColNum < 0 || !this.beanFilter.test(obj = this.instanceObj(fieldMap, formatter, row))) continue;
            if (Objects.nonNull(consumer)) {
                consumer.accept(obj);
                continue;
            }
            if (Objects.nonNull(function) && !(noStop = function.apply(obj)).booleanValue()) break;
        }
        log.info("Reading excel takes {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
    }

    private T instanceObj(Map<Integer, Field> fieldMap, DataFormatter formatter, Row row) {
        T obj;
        try {
            obj = this.dataType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        fieldMap.forEach((key, field) -> {
            Cell cell = row.getCell(key.intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (Objects.isNull(cell)) {
                return;
            }
            String content = formatter.formatCellValue(cell);
            ReadContext<Object> context = new ReadContext<Object>(obj, (Field)field, content, row.getRowNum(), (int)key);
            ReadConverterContext.convert(obj, context, this.exceptionFunction);
        });
        return obj;
    }
}

