/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.HtmlToExcelStreamFactory;
import com.github.liaochong.myexcel.core.SimpleStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamExcelBuilder
extends AbstractSimpleExcelBuilder
implements SimpleStreamExcelBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamExcelBuilder.class);
    private List<Field> filteredFields;
    private Class<?> dataType;
    private boolean fixedTitles;
    private ExecutorService executorService;
    private HtmlToExcelStreamFactory htmlToExcelStreamFactory;
    private Workbook workbook;
    private int capacity;
    private Consumer<Path> pathConsumer;
    private boolean cancel;
    private Class<?>[] groups;
    private int waitQueueSize = Runtime.getRuntime().availableProcessors() * 2;

    private DefaultStreamExcelBuilder() {
        this.noStyle = true;
        this.widthStrategy = WidthStrategy.NO_AUTO;
        this.workbookType = WorkbookType.SXLSX;
    }

    public static DefaultStreamExcelBuilder of(@NonNull Class<?> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = new DefaultStreamExcelBuilder();
        defaultStreamExcelBuilder.dataType = dataType;
        return defaultStreamExcelBuilder;
    }

    public static DefaultStreamExcelBuilder of(@NonNull Class<?> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = new DefaultStreamExcelBuilder();
        defaultStreamExcelBuilder.dataType = dataType;
        defaultStreamExcelBuilder.workbook = workbook;
        return defaultStreamExcelBuilder;
    }

    public static DefaultStreamExcelBuilder getInstance() {
        return new DefaultStreamExcelBuilder();
    }

    public static DefaultStreamExcelBuilder getInstance(Workbook workbook) {
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = new DefaultStreamExcelBuilder();
        defaultStreamExcelBuilder.workbook = workbook;
        return defaultStreamExcelBuilder;
    }

    public DefaultStreamExcelBuilder titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.titles = titles;
        return this;
    }

    public DefaultStreamExcelBuilder sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.sheetName = sheetName;
        return this;
    }

    public DefaultStreamExcelBuilder fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    public DefaultStreamExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        if (this.workbook != null) {
            throw new IllegalArgumentException("Workbook type confirmed, not modifiable");
        }
        this.workbookType = workbookType;
        return this;
    }

    public DefaultStreamExcelBuilder noStyle() {
        this.noStyle = true;
        return this;
    }

    public DefaultStreamExcelBuilder widthStrategy(@NonNull WidthStrategy widthStrategy) {
        if (widthStrategy == null) {
            throw new NullPointerException("widthStrategy is marked non-null but is null");
        }
        this.widthStrategy = widthStrategy;
        return this;
    }

    @Deprecated
    public DefaultStreamExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.widthStrategy = AutoWidthStrategy.map(autoWidthStrategy);
        return this;
    }

    public DefaultStreamExcelBuilder fixedTitles() {
        this.fixedTitles = true;
        return this;
    }

    public DefaultStreamExcelBuilder widths(int ... widths) {
        if (widths.length == 0) {
            return this;
        }
        this.widths = new HashMap(widths.length);
        int size = widths.length;
        for (int i = 0; i < size; ++i) {
            this.widths.put(i, widths[i]);
        }
        this.customWidthMap = this.widths;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder threadPool(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder hasStyle() {
        this.noStyle = false;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder capacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this.capacity = capacity;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder pathConsumer(Consumer<Path> pathConsumer) {
        this.pathConsumer = pathConsumer;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder groups(Class<?> ... groups) {
        this.groups = groups;
        return this;
    }

    public DefaultStreamExcelBuilder waitQueueSize(int waitQueueSize) {
        this.waitQueueSize = waitQueueSize;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder start() {
        if (this.dataType != null) {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.dataType);
            this.filteredFields = this.getFilteredFields(classFieldContainer, this.groups);
        }
        this.initStyleMap();
        Table table = this.createTable();
        this.htmlToExcelStreamFactory = new HtmlToExcelStreamFactory(this.waitQueueSize, this.executorService, this.pathConsumer, this.capacity, this.fixedTitles);
        this.htmlToExcelStreamFactory.widthStrategy(this.widthStrategy);
        if (this.workbook == null) {
            this.htmlToExcelStreamFactory.workbookType(this.workbookType);
        }
        this.htmlToExcelStreamFactory.start(table, this.workbook);
        List<Tr> head = this.createThead();
        if (head != null) {
            this.htmlToExcelStreamFactory.appendTitles(head);
        }
        return this;
    }

    @Override
    public void append(List<?> data) {
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (data == null || data.isEmpty()) {
            return;
        }
        boolean isMapBuild = data.stream().anyMatch(d -> d instanceof Map);
        if (isMapBuild) {
            for (Object datum : data) {
                Map d2 = (Map)datum;
                ArrayList contents = new ArrayList(d2.size());
                for (String fieldName : this.fieldDisplayOrder) {
                    Object val = d2.get(fieldName);
                    contents.add(Pair.of(val == null ? String.class : val.getClass(), val));
                }
                Tr tr = this.createTr(contents);
                this.htmlToExcelStreamFactory.append(tr);
            }
        } else {
            for (Object datum : data) {
                List<Pair<? extends Class, ?>> contents = this.getRenderContent(datum, this.filteredFields);
                Tr tr = this.createTr(contents);
                this.htmlToExcelStreamFactory.append(tr);
            }
        }
    }

    @Override
    public <T> void append(T data) {
        List<Pair<Class, ?>> contents;
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (data == null) {
            return;
        }
        if (data instanceof Map) {
            Map d = (Map)data;
            contents = new ArrayList(d.size());
            for (String fieldName : this.fieldDisplayOrder) {
                Object val = d.get(fieldName);
                contents.add(Pair.of(val == null ? String.class : val.getClass(), val));
            }
        } else {
            contents = this.getRenderContent(data, this.filteredFields);
        }
        Tr tr = this.createTr(contents);
        this.htmlToExcelStreamFactory.append(tr);
    }

    @Override
    public Workbook build() {
        return this.htmlToExcelStreamFactory.build();
    }

    @Override
    public List<Path> buildAsPaths() {
        return this.htmlToExcelStreamFactory.buildAsPaths();
    }

    @Override
    public Path buildAsZip(String fileName) {
        return this.htmlToExcelStreamFactory.buildAsZip(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelStreamFactory != null) {
            this.htmlToExcelStreamFactory.closeWorkbook();
        }
    }

    public void cancle() {
        this.cancel = true;
        this.htmlToExcelStreamFactory.cancel();
    }

    public void clear() {
        this.htmlToExcelStreamFactory.clear();
    }
}

