/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelBuilder;
import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;

public class FreemarkerExcelBuilder
extends AbstractExcelBuilder {
    private static final Configuration CFG = new Configuration(Configuration.VERSION_2_3_23);
    private Template template;

    public FreemarkerExcelBuilder() {
        this.widthStrategy(WidthStrategy.AUTO_WIDTH);
    }

    @Override
    public ExcelBuilder template(String path) {
        try {
            this.template = CFG.getTemplate(path);
            return this;
        }
        catch (IOException e) {
            throw ExcelBuildException.of("Failed to get freemarker template", e);
        }
    }

    @Override
    protected <T> void render(Map<String, T> data, Writer out) throws Exception {
        Objects.requireNonNull(this.template, "The template cannot be empty. Please set the template first.");
        this.template.process(data, out);
    }

    static {
        CFG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CFG.setDefaultEncoding("UTF-8");
        CFG.setClassLoaderForTemplateLoading(Thread.currentThread().getContextClassLoader(), "/");
    }
}

