/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelFactory;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.utils.FileExportUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HtmlToExcelStreamFactory
extends AbstractExcelFactory {
    private static final Logger log = LoggerFactory.getLogger(HtmlToExcelStreamFactory.class);
    private static final int XLSX_MAX_ROW_COUNT = 0x100000;
    private static final int XLS_MAX_ROW_COUNT = 65536;
    private static final Tr STOP_FLAG = new Tr(-1, 0);
    private int maxRowCountOfSheet = 0x100000;
    private Sheet sheet;
    private BlockingQueue<Tr> trWaitQueue;
    private boolean stop;
    private boolean exception;
    private long startTime;
    private String sheetName = "Sheet";
    private Map<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>();
    private int rowNum;
    private int sheetNum;
    private int maxColIndex;
    private int capacity;
    private int count;
    private List<Tr> titles;
    private List<Path> paths;
    private List<CompletableFuture> futures;
    private Consumer<Path> pathConsumer;
    private ExecutorService executorService;
    private boolean fixedTitles;

    public HtmlToExcelStreamFactory(int waitSize, ExecutorService executorService, Consumer<Path> pathConsumer, int capacity, boolean fixedTitles) {
        this.trWaitQueue = new LinkedBlockingQueue<Tr>(waitSize);
        this.executorService = executorService;
        this.pathConsumer = pathConsumer;
        this.capacity = capacity;
        this.fixedTitles = fixedTitles;
    }

    public void start(Table table, Workbook workbook) {
        log.info("Start build excel");
        if (workbook != null) {
            this.workbook = workbook;
        }
        this.startTime = System.currentTimeMillis();
        if (this.workbook == null) {
            this.workbookType(WorkbookType.SXLSX);
        }
        if (this.workbook instanceof HSSFWorkbook) {
            this.maxRowCountOfSheet = 65536;
        }
        this.initCellStyle(this.workbook);
        if (table != null) {
            this.sheetName = this.getRealSheetName(table.getCaption());
        }
        this.sheet = this.workbook.createSheet(this.sheetName);
        this.paths = new ArrayList<Path>();
        if (this.executorService == null) {
            Thread thread = new Thread(this::receive);
            thread.setName("Excel-builder-1");
            thread.start();
        } else {
            this.futures = new ArrayList<CompletableFuture>();
            CompletableFuture.runAsync(this::receive, this.executorService);
        }
    }

    public void appendTitles(List<Tr> trList) {
        this.titles = trList;
        trList.forEach(this::append);
    }

    public void append(Tr tr) {
        if (this.exception) {
            log.error("Received a termination command,an exception occurred while processing");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (this.stop) {
            log.error("Received a termination command,the build method has been called");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (tr == null) {
            log.warn("This tr is null and will be discarded");
            return;
        }
        try {
            this.trWaitQueue.put(tr);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void receive() {
        Tr tr = this.getTrFromQueue();
        if (this.maxColIndex == 0) {
            int tdSize = tr.getTdList().size();
            this.maxColIndex = tdSize > 0 ? tdSize - 1 : 0;
        }
        int totalSize = 0;
        try {
            while (tr != STOP_FLAG) {
                if (this.capacity > 0 && this.count == this.capacity) {
                    this.storeToTempFile();
                    this.initNewWorkbook();
                }
                if (this.rowNum == this.maxRowCountOfSheet) {
                    ++this.sheetNum;
                    this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
                    this.colWidthMap = new HashMap<Integer, Integer>();
                    this.sheet = this.workbook.createSheet(this.sheetName + " (" + this.sheetNum + ")");
                    this.rowNum = 0;
                    this.setTitles();
                }
                this.appendRow(tr);
                ++totalSize;
                tr.getColWidthMap().forEach((k, v) -> {
                    Integer val = this.colWidthMap.get(k);
                    if (val == null || v > val) {
                        this.colWidthMap.put((Integer)k, (Integer)v);
                    }
                });
                tr = this.getTrFromQueue();
            }
            log.info("Total size:{}", (Object)totalSize);
        }
        catch (Exception e) {
            log.error("An exception occurred while processing", (Throwable)e);
            this.exception = true;
            this.closeWorkbook();
            this.trWaitQueue.clear();
            this.trWaitQueue = null;
            TempFileOperator.deleteTempFiles(this.paths);
        }
    }

    private Tr getTrFromQueue() {
        try {
            return this.trWaitQueue.take();
        }
        catch (InterruptedException e) {
            this.closeWorkbook();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Workbook build() {
        this.waiting();
        this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
        this.freezeTitles(this.workbook);
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.workbook;
    }

    List<Path> buildAsPaths() {
        this.waiting();
        this.storeToTempFile();
        if (this.futures != null) {
            this.futures.forEach(CompletableFuture::join);
        }
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.paths.stream().filter(path -> Objects.nonNull(path) && path.toFile().exists()).collect(Collectors.toList());
    }

    protected void waiting() {
        if (this.exception) {
            throw new IllegalStateException("An exception occurred while processing");
        }
        this.stop = true;
        try {
            this.trWaitQueue.put(STOP_FLAG);
        }
        catch (InterruptedException e) {
            throw new ExcelBuildException("Stop queue failure", e);
        }
        while (!this.trWaitQueue.isEmpty()) {
        }
    }

    private void storeToTempFile() {
        boolean isXls = this.workbook instanceof HSSFWorkbook;
        String suffix = isXls ? ".xls" : ".xlsx";
        Path path = TempFileOperator.createTempFile("s_t_r_p", suffix);
        this.paths.add(path);
        try {
            if (this.executorService != null) {
                Workbook tempWorkbook = this.workbook;
                Sheet tempSheet = this.sheet;
                Map<Integer, Integer> tempColWidthMap = this.colWidthMap;
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    this.setColWidth(tempColWidthMap, tempSheet, this.maxColIndex);
                    this.freezeTitles(tempWorkbook);
                    try {
                        FileExportUtil.export(tempWorkbook, path.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.pathConsumer != null) {
                        this.pathConsumer.accept(path);
                    }
                }, this.executorService);
                this.futures.add(future);
            } else {
                this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
                this.freezeTitles(this.workbook);
                FileExportUtil.export(this.workbook, path.toFile());
                if (Objects.nonNull(this.pathConsumer)) {
                    this.pathConsumer.accept(path);
                }
            }
        }
        catch (IOException e) {
            this.closeWorkbook();
            TempFileOperator.deleteTempFiles(this.paths);
            throw new RuntimeException(e);
        }
    }

    private void freezeTitles(Workbook workbook) {
        if (this.fixedTitles && this.titles != null) {
            int size = workbook.getNumberOfSheets();
            for (int i = 0; i < size; ++i) {
                workbook.getSheetAt(i).createFreezePane(0, this.titles.size());
            }
        }
    }

    private void initNewWorkbook() {
        boolean isXls = this.workbook instanceof HSSFWorkbook;
        this.workbook = null;
        this.workbookType(isXls ? WorkbookType.XLS : WorkbookType.SXLSX);
        this.sheetNum = 0;
        this.rowNum = 0;
        this.count = 0;
        this.colWidthMap = new HashMap<Integer, Integer>();
        this.clearCache();
        this.initCellStyle(this.workbook);
        this.sheet = this.workbook.createSheet(this.sheetName);
        if (this.titles == null) {
            return;
        }
        this.setTitles();
    }

    private void setTitles() {
        for (Tr titleTr : this.titles) {
            this.appendRow(titleTr);
        }
    }

    private void appendRow(Tr tr) {
        tr.setIndex(this.rowNum);
        tr.getTdList().forEach(td -> td.setRow(this.rowNum));
        ++this.rowNum;
        ++this.count;
        this.createRow(tr, this.sheet);
    }

    Path buildAsZip(String fileName) {
        Objects.requireNonNull(fileName);
        this.waiting();
        boolean isXls = this.workbook instanceof HSSFWorkbook;
        this.storeToTempFile();
        if (Objects.nonNull(this.futures)) {
            this.futures.forEach(CompletableFuture::join);
        }
        String suffix = isXls ? ".xls" : ".xlsx";
        Path zipFile = TempFileOperator.createTempFile(fileName, ".zip");
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            int size = this.paths.size();
            for (int i = 1; i <= size; ++i) {
                Path path = this.paths.get(i - 1);
                ZipEntry zipEntry = new ZipEntry(fileName + " (" + i + ")" + suffix);
                out.putNextEntry(zipEntry);
                out.write(Files.readAllBytes(path));
                out.closeEntry();
            }
        }
        catch (IOException e) {
            this.closeWorkbook();
            throw new RuntimeException(e);
        }
        finally {
            TempFileOperator.deleteTempFiles(this.paths);
        }
        return zipFile;
    }

    public void cancel() {
        this.waiting();
        this.closeWorkbook();
        TempFileOperator.deleteTempFiles(this.paths);
    }

    public void clear() {
        this.closeWorkbook();
        TempFileOperator.deleteTempFiles(this.paths);
    }
}

