/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.CsvReadHandler;
import com.github.liaochong.myexcel.core.HSSFSaxReadHandler;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.XSSFSaxReadHandler;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.exception.StopReadException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import lombok.NonNull;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxExcelReader<T> {
    private static final Logger log = LoggerFactory.getLogger(SaxExcelReader.class);
    private static final int DEFAULT_SHEET_INDEX = 0;
    private List<T> result = new LinkedList<T>();
    private ReadConfig<T> readConfig = new ReadConfig(0);

    private SaxExcelReader(Class<T> dataType) {
        ((ReadConfig)this.readConfig).dataType = dataType;
    }

    public static <T> SaxExcelReader<T> of(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return new SaxExcelReader<T>(clazz);
    }

    public SaxExcelReader<T> sheet(Integer ... indexs) {
        ((ReadConfig)this.readConfig).sheetIndexs.clear();
        ((ReadConfig)this.readConfig).sheetIndexs.addAll(Arrays.asList(indexs));
        return this;
    }

    public SaxExcelReader<T> sheet(String ... sheetNames) {
        ((ReadConfig)this.readConfig).sheetNames.clear();
        ((ReadConfig)this.readConfig).sheetNames.addAll(Arrays.asList(sheetNames));
        return this;
    }

    public SaxExcelReader<T> rowFilter(Predicate<Row> rowFilter) {
        ((ReadConfig)this.readConfig).rowFilter = rowFilter;
        return this;
    }

    public SaxExcelReader<T> beanFilter(Predicate<T> beanFilter) {
        ((ReadConfig)this.readConfig).beanFilter = beanFilter;
        return this;
    }

    public SaxExcelReader<T> charset(String charset) {
        ((ReadConfig)this.readConfig).charset = charset;
        return this;
    }

    public SaxExcelReader<T> exceptionally(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        ((ReadConfig)this.readConfig).exceptionFunction = exceptionFunction;
        return this;
    }

    public List<T> read(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        this.doReadInputStream(fileInputStream);
        return this.result;
    }

    public List<T> read(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.doReadFile(file);
        return this.result;
    }

    public void readThen(@NonNull InputStream fileInputStream, Consumer<T> consumer) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        ((ReadConfig)this.readConfig).consumer = consumer;
        this.doReadInputStream(fileInputStream);
    }

    public void readThen(@NonNull File file, Consumer<T> consumer) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ((ReadConfig)this.readConfig).consumer = consumer;
        this.doReadFile(file);
    }

    public void readThen(@NonNull InputStream fileInputStream, Function<T, Boolean> function) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        ((ReadConfig)this.readConfig).function = function;
        this.doReadInputStream(fileInputStream);
    }

    public void readThen(@NonNull File file, Function<T, Boolean> function) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ((ReadConfig)this.readConfig).function = function;
        this.doReadFile(file);
    }

    private void doReadFile(@NonNull File file) {
        String suffix;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        switch (suffix = file.getName().substring(file.getName().lastIndexOf("."))) {
            case ".xlsx": {
                this.doReadXlsx(file);
                break;
            }
            case ".xls": {
                this.doReadXls(file);
                break;
            }
            case ".csv": {
                this.doReadCsv(file);
                break;
            }
            default: {
                throw new IllegalArgumentException("The file type does not match, and the file suffix must be one of .xlsx,.xls,.csv");
            }
        }
    }

    private void doReadXls(File file) {
        try {
            new HSSFSaxReadHandler<T>(file, this.result, this.readConfig).process();
        }
        catch (StopReadException stopReadException) {
        }
        catch (IOException e) {
            throw new SaxReadException("Fail to read file", e);
        }
    }

    private void doReadXlsx(File file) {
        try (OPCPackage p2 = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            this.process(p2);
        }
        catch (StopReadException p2) {
        }
        catch (Exception e) {
            throw new SaxReadException("Fail to read file", e);
        }
    }

    private void doReadCsv(File file) {
        try {
            new CsvReadHandler<T>(Files.newInputStream(file.toPath(), new OpenOption[0]), this.readConfig, this.result).read();
        }
        catch (StopReadException stopReadException) {
        }
        catch (Throwable throwable) {
            throw new ExcelReadException("Fail to read file", throwable);
        }
    }

    private void doReadXls(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        try {
            new HSSFSaxReadHandler<T>(fileInputStream, this.result, this.readConfig).process();
        }
        catch (StopReadException stopReadException) {
        }
        catch (IOException e) {
            throw new SaxReadException("Fail to read file inputStream", e);
        }
    }

    private void doReadCsv(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        try {
            new CsvReadHandler<T>(fileInputStream, this.readConfig, this.result).read();
        }
        catch (StopReadException stopReadException) {
            // empty catch block
        }
    }

    @NonNull
    private InputStream modifyInputStreamTypeIfNotMarkSupported(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        if (fileInputStream.markSupported()) {
            return fileInputStream;
        }
        return new BufferedInputStream(fileInputStream);
    }

    /*
     * Unable to fully structure code
     */
    private void doReadInputStream(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        try {
            is = FileMagic.prepareToCheckMagic((InputStream)fileInputStream);
            var3_4 = null;
            try {
                fm = FileMagic.valueOf((InputStream)is);
                switch (1.$SwitchMap$org$apache$poi$poifs$filesystem$FileMagic[fm.ordinal()]) {
                    case 1: {
                        this.doReadXls(is);
                        ** break;
lbl12:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        p = OPCPackage.open((InputStream)is);
                        var6_9 = null;
                        this.process(p);
                        if (p == null) break;
                        if (var6_9 == null) ** GOTO lbl28
                        try {
                            p.close();
                            ** break;
lbl23:
                            // 1 sources

                        }
                        catch (Throwable var7_10) {
                            var6_9.addSuppressed(var7_10);
                            ** break;
                        }
lbl27:
                        // 1 sources

                        break;
lbl28:
                        // 1 sources

                        p.close();
                        ** break;
lbl30:
                        // 1 sources

                        break;
                        catch (Throwable var7_11) {
                            try {
                                var6_9 = var7_11;
                                throw var7_11;
                            }
                            catch (Throwable var8_12) {
                                if (p != null) {
                                    if (var6_9 != null) {
                                        try {
                                            p.close();
                                        }
                                        catch (Throwable var9_13) {
                                            var6_9.addSuppressed(var9_13);
                                        }
                                    } else {
                                        p.close();
                                    }
                                }
                                throw var8_12;
                            }
                        }
                    }
                    default: {
                        this.doReadCsv(is);
                        break;
                    }
                }
            }
            catch (Throwable var4_7) {
                var3_4 = var4_7;
                throw var4_7;
            }
            finally {
                if (is != null) {
                    if (var3_4 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable var4_6) {
                            var3_4.addSuppressed(var4_6);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new SaxReadException("Fail to read file inputStream", throwable);
        }
    }

    private void process(OPCPackage xlsxPackage) throws IOException, OpenXML4JException, SAXException {
        long startTime = System.currentTimeMillis();
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(xlsxPackage);
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        if (!((ReadConfig)this.readConfig).sheetNames.isEmpty()) {
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                Throwable throwable = null;
                try {
                    if (!((ReadConfig)this.readConfig).sheetNames.contains(iter.getSheetName())) continue;
                    this.processSheet((SharedStrings)strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig), stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        } else {
            int index = 0;
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                Throwable throwable = null;
                try {
                    if (((ReadConfig)this.readConfig).sheetIndexs.contains(index)) {
                        this.processSheet((SharedStrings)strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig), stream);
                    }
                    ++index;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void processSheet(SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(null, null, strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public static class ReadConfig<T> {
        private Class<T> dataType;
        private Set<String> sheetNames = new HashSet<String>();
        private Set<Integer> sheetIndexs = new HashSet<Integer>();
        private Consumer<T> consumer;
        private Function<T, Boolean> function;
        private Predicate<Row> rowFilter = row -> true;
        private Predicate<T> beanFilter = bean -> true;
        private BiFunction<Throwable, ReadContext, Boolean> exceptionFunction = (t, c) -> false;
        private String charset = "UTF-8";

        public ReadConfig(int sheetIndex) {
            this.sheetIndexs.add(sheetIndex);
        }

        public Class<T> getDataType() {
            return this.dataType;
        }

        public Set<String> getSheetNames() {
            return this.sheetNames;
        }

        public Set<Integer> getSheetIndexs() {
            return this.sheetIndexs;
        }

        public Consumer<T> getConsumer() {
            return this.consumer;
        }

        public Function<T, Boolean> getFunction() {
            return this.function;
        }

        public Predicate<Row> getRowFilter() {
            return this.rowFilter;
        }

        public Predicate<T> getBeanFilter() {
            return this.beanFilter;
        }

        public BiFunction<Throwable, ReadContext, Boolean> getExceptionFunction() {
            return this.exceptionFunction;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setDataType(Class<T> dataType) {
            this.dataType = dataType;
        }

        public void setSheetNames(Set<String> sheetNames) {
            this.sheetNames = sheetNames;
        }

        public void setSheetIndexs(Set<Integer> sheetIndexs) {
            this.sheetIndexs = sheetIndexs;
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public void setFunction(Function<T, Boolean> function) {
            this.function = function;
        }

        public void setRowFilter(Predicate<Row> rowFilter) {
            this.rowFilter = rowFilter;
        }

        public void setBeanFilter(Predicate<T> beanFilter) {
            this.beanFilter = beanFilter;
        }

        public void setExceptionFunction(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
            this.exceptionFunction = exceptionFunction;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }
    }
}

