/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelBuilder;
import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafExcelBuilder
extends AbstractExcelBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThymeleafExcelBuilder.class);
    private static final TemplateEngine TEMPLATE_ENGINE = new TemplateEngine();
    private String filePath;

    public ThymeleafExcelBuilder() {
        this.widthStrategy(WidthStrategy.AUTO_WIDTH);
    }

    @Override
    public ExcelBuilder template(String path) {
        Objects.requireNonNull(path);
        if (!path.endsWith(".html")) {
            throw new IllegalArgumentException("ThymeleafExcelBuilder only supports files suffixed with .html");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.filePath = path;
        return this;
    }

    @Override
    protected <T> void render(Map<String, T> renderData, Writer out) throws Exception {
        Context context = new Context();
        context.setVariables(renderData);
        TEMPLATE_ENGINE.process(this.filePath, (IContext)context, out);
    }

    static {
        ClassLoaderTemplateResolver classLoaderTemplateResolver = new ClassLoaderTemplateResolver();
        classLoaderTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        classLoaderTemplateResolver.setCacheable(true);
        TEMPLATE_ENGINE.setTemplateResolver((ITemplateResolver)classLoaderTemplateResolver);
    }
}

