/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.Cell;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.exception.StopReadException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XSSFSaxReadHandler<T>
extends AbstractReadHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(XSSFSaxReadHandler.class);
    private Row currentRow;
    private int count;

    public XSSFSaxReadHandler(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        this.init(result, readConfig);
    }

    public void startRow(int rowNum) {
        this.currentRow = new Row(rowNum);
        this.obj = this.newInstance(this.dataType);
    }

    public void endRow(int rowNum) {
        this.initFieldMap(rowNum);
        if (!this.rowFilter.test(this.currentRow)) {
            return;
        }
        if (!this.beanFilter.test(this.obj)) {
            return;
        }
        ++this.count;
        if (this.consumer != null) {
            this.consumer.accept(this.obj);
        } else if (this.function != null) {
            Boolean noStop = (Boolean)this.function.apply(this.obj);
            if (!noStop.booleanValue()) {
                throw new StopReadException();
            }
        } else {
            this.result.add(this.obj);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (cellReference == null) {
            return;
        }
        short thisCol = new CellReference(cellReference).getCol();
        this.addTitleConsumer.accept(formattedValue, this.currentRow.getRowNum(), Integer.valueOf(thisCol));
        if (!this.rowFilter.test(this.currentRow)) {
            return;
        }
        if (this.isMapType) {
            ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), thisCol), formattedValue);
            return;
        }
        Field field = (Field)this.fieldMap.get(thisCol);
        if (field == null) {
            return;
        }
        ReadContext<Object> context = new ReadContext<Object>(this.obj, field, formattedValue, this.currentRow.getRowNum(), thisCol);
        ReadConverterContext.convert(this.obj, context, this.exceptionFunction);
    }

    public void endSheet() {
        log.info("Import completed, total number of rows {}", (Object)this.count);
    }
}

