/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter;

import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.BigDecimalWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.DateTimeWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.DropDownListWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.ImageWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.LinkWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.MappingWriteConverter;
import com.github.liaochong.myexcel.core.converter.writer.StringWriteConverter;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WriteConverterContext {
    private static final Pair<? extends Class, Object> NULL_PAIR = Pair.of(String.class, null);
    private static final List<WriteConverter> WRITE_CONVERTER_CONTAINER = new ArrayList<WriteConverter>();

    public static synchronized void registering(WriteConverter ... writeConverters) {
        Objects.requireNonNull(writeConverters);
        Collections.addAll(WRITE_CONVERTER_CONTAINER, writeConverters);
    }

    public static Pair<? extends Class, Object> convert(Field field, Object object) {
        Object result = ReflectUtil.getFieldValue(object, field);
        if (result == null) {
            return NULL_PAIR;
        }
        Optional<WriteConverter> writeConverterOptional = WRITE_CONVERTER_CONTAINER.stream().filter(writeConverter -> writeConverter.support(field, result)).findFirst();
        return writeConverterOptional.isPresent() ? writeConverterOptional.get().convert(field, result) : Pair.of(field.getType(), result);
    }

    static {
        WRITE_CONVERTER_CONTAINER.add(new DateTimeWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new StringWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new BigDecimalWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new DropDownListWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new LinkWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new MappingWriteConverter());
        WRITE_CONVERTER_CONTAINER.add(new ImageWriteConverter());
    }
}

