/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateReadConverter
extends AbstractReadConverter<Date> {
    @Override
    public Date doConvert(String v, Field field) {
        if (this.isDateNumber(v)) {
            long time = Long.parseLong(v);
            return new Date(time);
        }
        if (this.isDateDecimalNumber(v)) {
            long time = this.convertExcelNumberDateToMilli(v);
            return new Date(time);
        }
        String dateFormatPattern = this.getDateFormatPattern(field);
        SimpleDateFormat sdf = this.getSimpleDateFormat(dateFormatPattern);
        try {
            return sdf.parse(v);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

