/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TimestampReadConverter
extends AbstractReadConverter<Timestamp> {
    @Override
    protected Timestamp doConvert(String v, Field field) {
        if (this.isDateNumber(v)) {
            long time = Long.parseLong(v);
            return new Timestamp(time);
        }
        String dateFormatPattern = this.getDateFormatPattern(field);
        SimpleDateFormat sdf = this.getSimpleDateFormat(dateFormatPattern);
        try {
            return new Timestamp(sdf.parse(v).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

