/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClassFieldContainer {
    private Class<?> clazz;
    private List<Field> declaredFields = new ArrayList<Field>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private ClassFieldContainer parent;

    public Field getFieldByName(String fieldName) {
        return this.getFieldByName(fieldName, this);
    }

    public List<Field> getFieldsByAnnotation(Class<? extends Annotation> annotationClass) {
        Objects.requireNonNull(annotationClass);
        ArrayList<Field> annotationFields = new ArrayList<Field>();
        this.getFieldsByAnnotation(this, annotationClass, annotationFields);
        return annotationFields;
    }

    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getFieldsByContainer(this, fields);
        return fields;
    }

    private void getFieldsByContainer(ClassFieldContainer classFieldContainer, List<Field> fields) {
        fields.addAll(classFieldContainer.getDeclaredFields());
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (Objects.isNull(parentContainer)) {
            return;
        }
        this.getFieldsByContainer(parentContainer, fields);
    }

    private void getFieldsByAnnotation(ClassFieldContainer classFieldContainer, Class<? extends Annotation> annotationClass, List<Field> annotationFieldContainer) {
        List annotationFields = classFieldContainer.declaredFields.stream().filter(field -> field.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
        annotationFieldContainer.addAll(annotationFields);
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (Objects.isNull(parentContainer)) {
            return;
        }
        this.getFieldsByAnnotation(parentContainer, annotationClass, annotationFieldContainer);
    }

    private Field getFieldByName(String fieldName, ClassFieldContainer container) {
        Field field = container.getFieldMap().get(fieldName);
        if (Objects.nonNull(field)) {
            return field;
        }
        ClassFieldContainer parentContainer = container.getParent();
        if (Objects.isNull(parentContainer)) {
            return null;
        }
        return this.getFieldByName(fieldName, parentContainer);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<Field> getDeclaredFields() {
        return this.declaredFields;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public ClassFieldContainer getParent() {
        return this.parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setDeclaredFields(List<Field> declaredFields) {
        this.declaredFields = declaredFields;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public void setParent(ClassFieldContainer parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFieldContainer)) {
            return false;
        }
        ClassFieldContainer other = (ClassFieldContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        List<Field> this$declaredFields = this.getDeclaredFields();
        List<Field> other$declaredFields = other.getDeclaredFields();
        if (this$declaredFields == null ? other$declaredFields != null : !((Object)this$declaredFields).equals(other$declaredFields)) {
            return false;
        }
        Map<String, Field> this$fieldMap = this.getFieldMap();
        Map<String, Field> other$fieldMap = other.getFieldMap();
        if (this$fieldMap == null ? other$fieldMap != null : !((Object)this$fieldMap).equals(other$fieldMap)) {
            return false;
        }
        ClassFieldContainer this$parent = this.getParent();
        ClassFieldContainer other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassFieldContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        List<Field> $declaredFields = this.getDeclaredFields();
        result = result * 59 + ($declaredFields == null ? 43 : ((Object)$declaredFields).hashCode());
        Map<String, Field> $fieldMap = this.getFieldMap();
        result = result * 59 + ($fieldMap == null ? 43 : ((Object)$fieldMap).hashCode());
        ClassFieldContainer $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    public String toString() {
        return "ClassFieldContainer(clazz=" + this.getClazz() + ", declaredFields=" + this.getDeclaredFields() + ", fieldMap=" + this.getFieldMap() + ", parent=" + this.getParent() + ")";
    }
}

