/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.style;

import com.github.liaochong.myexcel.core.style.CustomColor;
import com.github.liaochong.myexcel.utils.ColorUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.awt.Color;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public final class FontStyle {
    public static final String FONT_COLOR = "color";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_STYLE = "font-style";
    public static final String TEXT_DECORATION = "text-decoration";
    public static final String ITALIC = "italic";
    public static final String LINE_THROUGH = "line-through";
    public static final String UNDERLINE = "underline";
    public static final String BOLD = "bold";
    public static final short DEFAULT_FONT_SIZE = 12;

    public static void setFont(Supplier<Font> fontSupplier, CellStyle cellStyle, Map<String, String> tdStyle, Map<String, Font> fontMap, CustomColor customColor) {
        String fontColor;
        String textDecoration;
        String italic;
        String fontFamily;
        String cacheKey = FontStyle.getCacheKey(tdStyle);
        if (fontMap.get(cacheKey) != null) {
            cellStyle.setFont(fontMap.get(cacheKey));
            return;
        }
        Font font = null;
        String fs = tdStyle.get(FONT_SIZE);
        if (fs != null) {
            short fontSize = (short)TdUtil.getValue(fs);
            font = fontSupplier.get();
            font.setFontHeightInPoints(fontSize);
        }
        if ((fontFamily = tdStyle.get(FONT_FAMILY)) != null) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font.setFontName(fontFamily);
        }
        if (ITALIC.equals(italic = tdStyle.get(FONT_STYLE))) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font.setItalic(true);
        }
        if (LINE_THROUGH.equals(textDecoration = tdStyle.get(TEXT_DECORATION))) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font.setStrikeout(true);
        } else if (UNDERLINE.equals(textDecoration)) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font.setUnderline((byte)1);
        }
        String fontWeight = tdStyle.get(FONT_WEIGHT);
        if (BOLD.equals(fontWeight)) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font.setBold(true);
        }
        if (StringUtil.isNotBlank(fontColor = tdStyle.get(FONT_COLOR))) {
            font = FontStyle.createFontIfNull(fontSupplier, font);
            font = FontStyle.setFontColor(font, customColor, fontColor);
        }
        if (font != null) {
            cellStyle.setFont(font);
            fontMap.put(cacheKey, font);
        }
    }

    private static Font setFontColor(Font font, CustomColor customColor, String fontColor) {
        Short colorPredefined = ColorUtil.getPredefinedColorIndex(fontColor);
        if (colorPredefined != null) {
            font.setColor(colorPredefined.shortValue());
            return font;
        }
        int[] rgb = ColorUtil.getRGBByColor(fontColor);
        if (rgb == null) {
            return null;
        }
        if (customColor.isXls()) {
            short index = ColorUtil.getCustomColorIndex(customColor, rgb);
            font.setColor(index);
        } else {
            ((XSSFFont)font).setColor(new XSSFColor(new Color(rgb[0], rgb[1], rgb[2]), (IndexedColorMap)customColor.getDefaultIndexedColorMap()));
        }
        return font;
    }

    private static Font createFontIfNull(Supplier<Font> fontSupplier, Font font) {
        return font == null ? fontSupplier.get() : font;
    }

    private static String getCacheKey(Map<String, String> tdStyle) {
        StringBuilder result = new StringBuilder();
        FontStyle.appendKey(tdStyle, FONT_SIZE, result);
        FontStyle.appendKey(tdStyle, FONT_FAMILY, result);
        FontStyle.appendKey(tdStyle, FONT_STYLE, result);
        FontStyle.appendKey(tdStyle, TEXT_DECORATION, result);
        FontStyle.appendKey(tdStyle, FONT_WEIGHT, result);
        FontStyle.appendKey(tdStyle, FONT_COLOR, result);
        return result.toString();
    }

    private static void appendKey(Map<String, String> tdStyle, String styleName, StringBuilder result) {
        String style = tdStyle.get(styleName);
        if (style != null) {
            result.append(styleName).append(":").append(style).append("_");
        }
    }
}

