/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ReflectUtil {
    private static final WeakCache<Class<?>, Map<Integer, Field>> FIELD_CACHE = new WeakCache();
    private static final WeakCache<Class<?>, Map<String, Field>> TITLE_FIELD_CACHE = new WeakCache();

    public static ClassFieldContainer getAllFieldsOfClass(Class<?> clazz) {
        ClassFieldContainer container = new ClassFieldContainer();
        ReflectUtil.getAllFieldsOfClass(clazz, container);
        return container;
    }

    public static Map<Integer, Field> getFieldMapOfExcelColumn(Class<?> dataType) {
        if (dataType == Map.class) {
            return Collections.emptyMap();
        }
        Map<Integer, Field> fieldMap = FIELD_CACHE.get(dataType);
        if (fieldMap != null) {
            return fieldMap;
        }
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
        List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        if (fields.isEmpty()) {
            throw new IllegalStateException("There is no field with @ExcelColumn");
        }
        fieldMap = new HashMap<Integer, Field>(fields.size());
        for (Field field : fields) {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            int index = excelColumn.index();
            if (index < 0) continue;
            Field f = fieldMap.get(index);
            if (Objects.nonNull(f)) {
                throw new IllegalStateException("Index cannot be repeated. Please check it.");
            }
            field.setAccessible(true);
            fieldMap.put(index, field);
        }
        FIELD_CACHE.cache(dataType, fieldMap);
        return fieldMap;
    }

    public static Map<String, Field> getFieldMapOfTitleExcelColumn(Class<?> dataType) {
        if (dataType == Map.class) {
            return Collections.emptyMap();
        }
        Map<String, Field> fieldMap = TITLE_FIELD_CACHE.get(dataType);
        if (fieldMap != null) {
            return fieldMap;
        }
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
        List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        if (fields.isEmpty()) {
            throw new IllegalStateException("There is no field with @ExcelColumn");
        }
        fieldMap = new HashMap<String, Field>(fields.size());
        for (Field field : fields) {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            String title = excelColumn.title();
            if (title.isEmpty()) continue;
            Field f = fieldMap.get(title);
            if (f != null) {
                throw new IllegalStateException("Title cannot be repeated. Please check it.");
            }
            field.setAccessible(true);
            fieldMap.put(title, field);
        }
        TITLE_FIELD_CACHE.cache(dataType, fieldMap);
        return fieldMap;
    }

    public static Object getFieldValue(Object o, Field field) {
        if (o == null || field == null) {
            return null;
        }
        try {
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void getAllFieldsOfClass(Class<?> clazz, ClassFieldContainer container) {
        Field[] fields;
        container.setClazz(clazz);
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            container.getDeclaredFields().add(field);
            container.getFieldMap().put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            ClassFieldContainer parentContainer = new ClassFieldContainer();
            container.setParent(parentContainer);
            ReflectUtil.getAllFieldsOfClass(clazz.getSuperclass(), parentContainer);
        }
    }

    public static boolean isNumber(Class clazz) {
        return clazz == Double.class || clazz == Double.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Byte.class || clazz == Byte.TYPE || clazz == BigDecimal.class;
    }

    public static boolean isBool(Class clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static int sortFields(Field field1, Field field2) {
        int defaultOrder;
        ExcelColumn excelColumn1 = field1.getAnnotation(ExcelColumn.class);
        ExcelColumn excelColumn2 = field2.getAnnotation(ExcelColumn.class);
        if (excelColumn1 == null && excelColumn2 == null) {
            return 0;
        }
        int order1 = defaultOrder = 0;
        if (excelColumn1 != null) {
            order1 = excelColumn1.order();
        }
        int order2 = defaultOrder;
        if (excelColumn2 != null) {
            order2 = excelColumn2.order();
        }
        if (order1 == order2) {
            return 0;
        }
        return order1 > order2 ? 1 : -1;
    }

    public static boolean isFieldSelected(List<Class<?>> selectedGroupList, Field field) {
        if (selectedGroupList.isEmpty()) {
            return true;
        }
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        if (excelColumn == null) {
            return false;
        }
        Class<?>[] groupArr = excelColumn.groups();
        if (groupArr.length == 0) {
            return false;
        }
        List reservedGroupList = Arrays.stream(groupArr).collect(Collectors.toList());
        return reservedGroupList.stream().anyMatch(selectedGroupList::contains);
    }

    private ReflectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

