/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.mbp;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.config.builder.Controller;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.builder.Mapper;
import com.baomidou.mybatisplus.generator.config.builder.Service;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.fill.Column;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenSetting;
import com.github.davidfantasy.mybatisplus.generatorui.dto.OutputFileInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.UserConfig;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.BeetlTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.NameConverter;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.TemplateVaribleInjecter;
import com.github.davidfantasy.mybatisplus.generatorui.service.UserConfigStore;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ControllerStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.EntityStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.MapperStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.MapperXmlStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ServiceImplStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ServiceStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MbpGenerator {
    private static final Logger log = LoggerFactory.getLogger(MbpGenerator.class);
    @Autowired
    private DataSourceConfig ds;
    @Autowired
    private GeneratorConfig generatorConfig;
    @Autowired
    private UserConfigStore userConfigStore;
    @Autowired
    private ProjectPathResolver projectPathResolver;
    @Autowired
    private BeetlTemplateEngine beetlTemplateEngine;

    public void genCodeBatch(GenSetting genSetting, List<String> tables) {
        this.checkGenSetting(genSetting);
        this.projectPathResolver.refreshBaseProjectPath(genSetting.getRootPath());
        UserConfig userConfig = this.userConfigStore.getDefaultUserConfig();
        FastAutoGenerator.create((String)this.ds.getUrl(), (String)this.ds.getUsername(), (String)this.ds.getPassword()).dataSourceConfig(builder -> {
            builder.schema(this.generatorConfig.getSchemaName());
            builder.typeConvert(this.generatorConfig.getTypeConvert());
        }).globalConfig(builder -> {
            builder.dateType(this.generatorConfig.getDateType());
            builder.outputDir(this.projectPathResolver.getSourcePath());
            builder.author(genSetting.getAuthor());
            if (userConfig.getEntityStrategy().isSwagger2()) {
                builder.enableSwagger();
            }
        }).templateEngine((AbstractTemplateEngine)this.beetlTemplateEngine).packageConfig(builder -> this.configPackage((PackageConfig.Builder)builder, genSetting.getModuleName(), userConfig)).templateConfig(builder -> this.configTemplate((TemplateConfig.Builder)builder, genSetting.getChoosedOutputFiles(), userConfig)).injectionConfig(builder -> this.configInjection((InjectionConfig.Builder)builder, userConfig, genSetting)).strategyConfig(builder -> {
            builder.addInclude(String.join((CharSequence)",", tables)).disableSqlFilter().enableSkipView();
            this.configEntity(builder.entityBuilder(), userConfig.getEntityStrategy(), genSetting.isOverride());
            this.configMapper(builder.mapperBuilder(), userConfig.getMapperStrategy(), userConfig.getMapperXmlStrategy(), genSetting.isOverride());
            this.configService(builder.serviceBuilder(), userConfig.getServiceStrategy(), userConfig.getServiceImplStrategy());
            this.configController(builder.controllerBuilder(), userConfig.getControllerStrategy());
        }).execute();
    }

    private void configPackage(PackageConfig.Builder builder, String moduleName, UserConfig userConfig) {
        String mapperXmlOutputPath = this.getOutputPathByFileType("Mapper.xml", userConfig);
        if (!StrUtil.isEmpty((CharSequence)moduleName)) {
            mapperXmlOutputPath = mapperXmlOutputPath + File.separator + moduleName;
        }
        String entityPkg = PathUtil.joinPackage(userConfig.getEntityInfo().getOutputPackage(), moduleName);
        String mapperPkg = PathUtil.joinPackage(userConfig.getMapperInfo().getOutputPackage(), moduleName);
        String servicePkg = PathUtil.joinPackage(userConfig.getServiceInfo().getOutputPackage(), moduleName);
        String serviceImplPkg = PathUtil.joinPackage(userConfig.getServiceImplInfo().getOutputPackage(), moduleName);
        String controllerPkg = PathUtil.joinPackage(userConfig.getControllerInfo().getOutputPackage(), moduleName);
        builder.parent("").moduleName("").entity(entityPkg).controller(controllerPkg).mapper(mapperPkg).service(servicePkg).serviceImpl(serviceImplPkg).pathInfo(Collections.singletonMap(OutputFile.xml, mapperXmlOutputPath));
    }

    private void configTemplate(TemplateConfig.Builder builder, List<String> choosedFileTypes, UserConfig userConfig) {
        builder.entity(this.findTemplatePath("Entity", userConfig));
        builder.mapper(this.findTemplatePath("Mapper.java", userConfig));
        builder.xml(this.findTemplatePath("Mapper.xml", userConfig));
        builder.service(this.findTemplatePath("Service", userConfig));
        builder.serviceImpl(this.findTemplatePath("ServiceImpl", userConfig));
        builder.controller(this.findTemplatePath("Controller", userConfig));
        if (!choosedFileTypes.contains("Entity")) {
            builder.disable(new TemplateType[]{TemplateType.ENTITY});
        }
        if (!choosedFileTypes.contains("Mapper.java")) {
            builder.disable(new TemplateType[]{TemplateType.MAPPER});
        }
        if (!choosedFileTypes.contains("Mapper.xml")) {
            builder.disable(new TemplateType[]{TemplateType.XML});
        }
        if (!choosedFileTypes.contains("Service")) {
            builder.disable(new TemplateType[]{TemplateType.SERVICE});
        }
        if (!choosedFileTypes.contains("ServiceImpl")) {
            builder.disable(new TemplateType[]{TemplateType.SERVICE_IMPL});
        }
        if (!choosedFileTypes.contains("Controller")) {
            builder.disable(new TemplateType[]{TemplateType.CONTROLLER});
        }
    }

    private void configInjection(InjectionConfig.Builder builder, UserConfig userConfig, GenSetting genSetting) {
        builder.beforeOutputFile((tableInfo, objectMap) -> {
            TemplateVaribleInjecter varibleInjecter = this.generatorConfig.getTemplateVaribleInjecter();
            HashMap vars = null;
            if (varibleInjecter != null) {
                vars = varibleInjecter.getCustomTemplateVaribles((TableInfo)tableInfo);
            }
            if (vars == null) {
                vars = Maps.newHashMap();
            }
            HashMap controllerMethodsVar = Maps.newHashMap();
            for (String method : genSetting.getChoosedControllerMethods()) {
                controllerMethodsVar.put(method, true);
            }
            if (controllerMethodsVar.size() > 0) {
                controllerMethodsVar.put("hasMethod", true);
            }
            vars.put("controllerMethods", controllerMethodsVar);
            if (!StrUtil.isEmpty((CharSequence)this.generatorConfig.getSchemaName())) {
                vars.put("schemaName", this.generatorConfig.getSchemaName() + ".");
            }
            objectMap.putAll(vars);
        });
        for (OutputFileInfo outputFileInfo : userConfig.getOutputFiles()) {
            if (outputFileInfo.isBuiltIn() || !genSetting.getChoosedOutputFiles().contains(outputFileInfo.getFileType())) continue;
            CustomFile.Builder fileBuilder = new CustomFile.Builder();
            fileBuilder.fileName(outputFileInfo.getFileType());
            fileBuilder.templatePath(outputFileInfo.getTemplatePath());
            fileBuilder.packageName(outputFileInfo.getOutputPackage());
            if (genSetting.isOverride()) {
                fileBuilder.enableFileOverride();
            }
            builder.customFile(fileBuilder.build());
        }
    }

    private void checkGenSetting(GenSetting genSetting) {
        if (StrUtil.isEmpty((CharSequence)genSetting.getRootPath())) {
            throw new ServiceException("\u76ee\u6807\u9879\u76ee\u6839\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
        genSetting.setRootPath(this.projectPathResolver.getUTF8String(genSetting.getRootPath()));
        if (!FileUtil.isDirectory((String)genSetting.getRootPath())) {
            throw new ServiceException("\u76ee\u6807\u9879\u76ee\u6839\u76ee\u5f55\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u76ee\u5f55\u6709\u6548\u4e14\u5b58\u5728\uff1a" + genSetting.getRootPath());
        }
        if (!genSetting.getRootPath().endsWith(File.separator)) {
            genSetting.setRootPath(genSetting.getRootPath() + File.separator);
        }
    }

    private void configEntity(Entity.Builder entityBuilder, EntityStrategy entityStrategy, boolean fileOverride) {
        final NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
        entityBuilder.idType(this.generatorConfig.getIdType());
        entityBuilder.nameConvert(new INameConvert(){

            @Nonnull
            public String entityNameConvert(@Nonnull TableInfo tableInfo) {
                return nameConverter.entityNameConvert(tableInfo.getName());
            }

            @Nonnull
            public String propertyNameConvert(@Nonnull TableField field) {
                return nameConverter.propertyNameConvert(field.getName());
            }
        });
        entityBuilder.superClass(entityStrategy.getSuperEntityClass());
        if (fileOverride) {
            entityBuilder.enableFileOverride();
        }
        if (!entityStrategy.isEntitySerialVersionUID()) {
            entityBuilder.disableSerialVersionUID();
        }
        if (entityStrategy.isEntityBuilderModel()) {
            entityBuilder.enableChainModel();
        }
        if (entityStrategy.isEntityLombokModel()) {
            entityBuilder.enableLombok();
        }
        if (entityStrategy.isEntityBooleanColumnRemoveIsPrefix()) {
            entityBuilder.enableRemoveIsPrefix();
        }
        if (entityStrategy.isEntityTableFieldAnnotationEnable()) {
            entityBuilder.enableTableFieldAnnotation();
        }
        if (entityStrategy.isActiveRecord()) {
            entityBuilder.enableActiveRecord();
        }
        if (!StrUtil.isEmpty((CharSequence)entityStrategy.getVersionFieldName())) {
            entityBuilder.versionColumnName(entityStrategy.getVersionFieldName());
            entityBuilder.versionPropertyName(entityStrategy.getVersionFieldName());
        }
        if (!StrUtil.isEmpty((CharSequence)entityStrategy.getLogicDeleteFieldName())) {
            entityBuilder.logicDeleteColumnName(entityStrategy.getLogicDeleteFieldName());
            entityBuilder.logicDeletePropertyName(entityStrategy.getLogicDeleteFieldName());
        }
        if (entityStrategy.getSuperEntityColumns() != null) {
            entityBuilder.addSuperEntityColumns(entityStrategy.getSuperEntityColumns());
        }
        if (entityStrategy.getTableFills() != null && !entityStrategy.getTableFills().isEmpty()) {
            ArrayList<Column> tableFills = new ArrayList<Column>();
            for (String tableFillStr : entityStrategy.getTableFills()) {
                if (StrUtil.isEmpty((CharSequence)tableFillStr)) continue;
                String[] tmp = tableFillStr.split(":");
                Column tableFill = new Column(tmp[0], FieldFill.valueOf((String)tmp[1].toUpperCase()));
                tableFills.add(tableFill);
            }
            entityBuilder.addTableFills(tableFills);
        }
        entityBuilder.idType(this.generatorConfig.getIdType());
        entityBuilder.convertFileName(entityName -> entityName);
    }

    private void configMapper(Mapper.Builder mapperBuilder, MapperStrategy mapperStrategy, MapperXmlStrategy mapperXmlStrategy, boolean fileOverride) {
        NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
        if (mapperStrategy.getSuperMapperClass() != null) {
            mapperBuilder.superClass(mapperStrategy.getSuperMapperClass());
        }
        if (mapperXmlStrategy.isBaseResultMap()) {
            mapperBuilder.enableBaseResultMap();
            mapperBuilder.enableBaseColumnList();
        }
        mapperBuilder.convertMapperFileName(nameConverter::mapperNameConvert);
        mapperBuilder.convertXmlFileName(nameConverter::mapperXmlNameConvert);
        if (fileOverride) {
            mapperBuilder.enableFileOverride();
        }
    }

    private void configService(Service.Builder serviceBuilder, ServiceStrategy serviceStrategy, ServiceImplStrategy serviceImplStrategy) {
        NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
        if (serviceStrategy.getSuperServiceClass() != null) {
            serviceBuilder.superServiceClass(serviceStrategy.getSuperServiceClass());
        }
        if (serviceImplStrategy.getSuperServiceImplClass() != null) {
            serviceBuilder.superServiceImplClass(serviceImplStrategy.getSuperServiceImplClass());
        }
        serviceBuilder.convertServiceFileName(nameConverter::serviceNameConvert);
        serviceBuilder.convertServiceImplFileName(nameConverter::serviceImplNameConvert);
    }

    private void configController(Controller.Builder controllerBuilder, ControllerStrategy controllerStrategy) {
        NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
        if (controllerStrategy.isRestControllerStyle()) {
            controllerBuilder.enableRestStyle();
        }
        if (controllerStrategy.isControllerMappingHyphenStyle()) {
            controllerBuilder.enableHyphenStyle();
        }
        if (controllerStrategy.getSuperControllerClass() != null) {
            controllerBuilder.superClass(controllerStrategy.getSuperControllerClass());
        }
        controllerBuilder.convertFileName(nameConverter::controllerNameConvert);
    }

    private OutputFileInfo findFileConfigByType(String fileType, UserConfig userConfig) {
        for (OutputFileInfo outputFileInfo : userConfig.getOutputFiles()) {
            if (!fileType.equals(outputFileInfo.getFileType())) continue;
            return outputFileInfo;
        }
        return null;
    }

    private String getOutputPathByFileType(String fileType, UserConfig userConfig) {
        return this.projectPathResolver.convertPackageToPath(Objects.requireNonNull(this.findFileConfigByType(fileType, userConfig)).getOutputLocation());
    }

    private String findTemplatePath(String fileType, UserConfig userConfig) {
        return Objects.requireNonNull(this.findFileConfigByType(fileType, userConfig)).getAvailableTemplatePath();
    }

    public MbpGenerator(DataSourceConfig ds, GeneratorConfig generatorConfig, UserConfigStore userConfigStore, ProjectPathResolver projectPathResolver, BeetlTemplateEngine beetlTemplateEngine) {
        this.ds = ds;
        this.generatorConfig = generatorConfig;
        this.userConfigStore = userConfigStore;
        this.projectPathResolver = projectPathResolver;
        this.beetlTemplateEngine = beetlTemplateEngine;
    }
}

