/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.OutputFileInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.UserConfig;
import com.github.davidfantasy.mybatisplus.generatorui.util.JsonUtil;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.github.davidfantasy.mybatisplus.generatorui.util.TemplateUtil;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UserConfigStore {
    private static final Logger log = LoggerFactory.getLogger(UserConfigStore.class);
    private String storeDir;
    private String userConfigPath;
    @Autowired
    private ProjectPathResolver pathResolver;
    @Autowired
    private GeneratorConfig generatorConfig;

    @PostConstruct
    public void init() {
        this.storeDir = PathUtil.joinPath(System.getProperty("user.home"), ".mybatis-plus-generator-ui", this.generatorConfig.getBasePackage());
        this.userConfigPath = this.storeDir + File.separator + "user-config.json";
    }

    public String getTemplateStoreDir() {
        return PathUtil.joinPath(this.storeDir, "template");
    }

    public UserConfig getDefaultUserConfig() {
        UserConfig userConfig = this.getUserConfigFromFile();
        if (userConfig == null) {
            userConfig = new UserConfig();
            userConfig.setOutputFiles(this.getBuiltInFileInfo());
        }
        return userConfig;
    }

    public UserConfig getUserConfigFromFile() {
        if (!FileUtil.exist((String)this.userConfigPath)) {
            return null;
        }
        String userConfigStr = FileUtil.readString((String)this.userConfigPath, (Charset)Charset.forName("utf-8"));
        try {
            return JsonUtil.json2obj(userConfigStr, UserConfig.class);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
    }

    public void saveUserConfig(UserConfig userConfig) throws IOException {
        if (userConfig == null) {
            throw new ServiceException("\u4e0d\u80fd\u5199\u5165\u7a7a\u7684\u7528\u6237\u914d\u7f6e");
        }
        String configStr = JsonUtil.obj2json(userConfig);
        File userConfigFile = new File(this.userConfigPath);
        if (userConfigFile.exists()) {
            userConfigFile.delete();
        }
        Files.createParentDirs((File)userConfigFile);
        userConfigFile.createNewFile();
        FileUtil.writeFromStream((InputStream)new ByteArrayInputStream(configStr.getBytes(Charset.forName("utf-8"))), (File)userConfigFile);
    }

    public String uploadTemplate(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        assert (fileName != null);
        String fileSuffix = fileName.substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        String saveFileName = fileName.substring(0, fileName.lastIndexOf(fileSuffix)) + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String savePath = PathUtil.joinPath(this.getTemplateStoreDir(), saveFileName);
        log.info("\u6a21\u677f\u4e0a\u4f20\u8def\u5f84\u4e3a\uff1a{}", (Object)savePath);
        File saveFile = new File(savePath);
        try {
            FileUtil.writeFromStream((InputStream)file.getInputStream(), (File)saveFile);
        }
        catch (IOException e) {
            throw new ServiceException("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5931\u8d25", e);
        }
        return "file:" + savePath;
    }

    public boolean checkUserConfigExisted() {
        return FileUtil.exist((String)this.storeDir);
    }

    public void importProjectConfig(String sourcePkg) throws IOException {
        String configHomePath = PathUtil.joinPath(System.getProperty("user.home"), ".mybatis-plus-generator-ui");
        if (!FileUtil.exist((String)configHomePath)) {
            throw new ServiceException("\u914d\u7f6e\u4e3b\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + configHomePath);
        }
        File[] files = FileUtil.ls((String)configHomePath);
        boolean flag = false;
        for (File file : files) {
            if (!file.isDirectory() || !file.getName().equals(sourcePkg)) continue;
            File projectConfigDir = new File(this.storeDir);
            FileUtil.copyContent((File)file, (File)projectConfigDir, (boolean)true);
            flag = true;
            break;
        }
        if (!flag) {
            throw new ServiceException("\u672a\u627e\u5230\u5f85\u5bfc\u5165\u7684\u6e90\u9879\u76ee\u914d\u7f6e");
        }
        String sourceProjectConfigPath = PathUtil.joinPath(System.getProperty("user.home"), ".mybatis-plus-generator-ui", sourcePkg);
        String targetProjectConfigPath = this.storeDir;
        UserConfig currentUserConfig = new UserConfig();
        currentUserConfig.setOutputFiles(this.getBuiltInFileInfo());
        currentUserConfig.merge(this.getUserConfigFromFile(), sourceProjectConfigPath, targetProjectConfigPath);
        this.saveUserConfig(currentUserConfig);
    }

    public List<String> getAllSavedProject() {
        File[] files;
        String configHomePath = PathUtil.joinPath(System.getProperty("user.home"), ".mybatis-plus-generator-ui");
        if (!FileUtil.exist((String)configHomePath)) {
            return Collections.emptyList();
        }
        ArrayList projects = Lists.newArrayList();
        for (File file : files = FileUtil.ls((String)configHomePath)) {
            if (!file.isDirectory()) continue;
            projects.add(file.getName());
        }
        return projects;
    }

    private List<OutputFileInfo> getBuiltInFileInfo() {
        ArrayList builtInFiles = Lists.newArrayList();
        OutputFileInfo entityFile = new OutputFileInfo();
        entityFile.setBuiltIn(true);
        entityFile.setFileType("Entity");
        entityFile.setOutputLocation(this.pathResolver.resolveEntityPackage());
        entityFile.setTemplateName(TemplateUtil.fileType2TemplateName(entityFile.getFileType()));
        builtInFiles.add(entityFile);
        OutputFileInfo mapperXmlFile = new OutputFileInfo();
        mapperXmlFile.setBuiltIn(true);
        mapperXmlFile.setFileType("Mapper.xml");
        mapperXmlFile.setOutputLocation(this.pathResolver.resolveMapperXmlPackage());
        mapperXmlFile.setTemplateName(TemplateUtil.fileType2TemplateName(mapperXmlFile.getFileType()));
        builtInFiles.add(mapperXmlFile);
        OutputFileInfo mapperFile = new OutputFileInfo();
        mapperFile.setBuiltIn(true);
        mapperFile.setFileType("Mapper.java");
        mapperFile.setOutputLocation(this.pathResolver.resolveMapperPackage());
        mapperFile.setTemplateName(TemplateUtil.fileType2TemplateName(mapperFile.getFileType()));
        builtInFiles.add(mapperFile);
        OutputFileInfo serviceFile = new OutputFileInfo();
        serviceFile.setBuiltIn(true);
        serviceFile.setFileType("Service");
        serviceFile.setOutputLocation(this.pathResolver.resolveServicePackage());
        serviceFile.setTemplateName(TemplateUtil.fileType2TemplateName(serviceFile.getFileType()));
        builtInFiles.add(serviceFile);
        OutputFileInfo serviceImplFile = new OutputFileInfo();
        serviceImplFile.setBuiltIn(true);
        serviceImplFile.setFileType("ServiceImpl");
        serviceImplFile.setOutputLocation(this.pathResolver.resolveServiceImplPackage());
        serviceImplFile.setTemplateName(TemplateUtil.fileType2TemplateName(serviceImplFile.getFileType()));
        builtInFiles.add(serviceImplFile);
        OutputFileInfo controllerFile = new OutputFileInfo();
        controllerFile.setBuiltIn(true);
        controllerFile.setFileType("Controller");
        controllerFile.setOutputLocation(this.pathResolver.resolveControllerPackage());
        controllerFile.setTemplateName(TemplateUtil.fileType2TemplateName(controllerFile.getFileType()));
        builtInFiles.add(controllerFile);
        return builtInFiles;
    }
}

