/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.HttpsServer;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.parser.HttpServerParser;
import com.github.dreamhead.moco.parser.SocketServerParser;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Optional;

public final class MocoJsonRunner {
    private static HttpServerParser parser = new HttpServerParser();

    public static HttpServer jsonHttpServer(int port, Resource resource) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return MocoJsonRunner.parseHttpServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.of(port));
    }

    public static HttpServer jsonHttpServer(Resource resource) {
        return MocoJsonRunner.parseHttpServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.empty());
    }

    public static HttpsServer jsonHttpsServer(Resource resource, HttpsCertificate certificate) {
        Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null");
        ActualHttpServer httpsServer = (ActualHttpServer)Moco.httpsServer((HttpsCertificate)certificate, (MocoConfig[])new MocoConfig[0]);
        return (HttpsServer)httpsServer.mergeServer((BaseActualServer)((ActualHttpServer)MocoJsonRunner.parseHttpServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.empty())));
    }

    public static HttpsServer jsonHttpsServer(int port, Resource resource, HttpsCertificate certificate) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null");
        ActualHttpServer httpsServer = (ActualHttpServer)Moco.httpsServer((int)port, (HttpsCertificate)certificate, (MocoConfig[])new MocoConfig[0]);
        return (HttpsServer)httpsServer.mergeServer((BaseActualServer)((ActualHttpServer)MocoJsonRunner.parseHttpServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.of(port))));
    }

    public static SocketServer jsonSocketServer(int port, Resource resource) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return MocoJsonRunner.jsonSocketServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.of(port));
    }

    public static SocketServer jsonSocketServer(Resource resource) {
        return MocoJsonRunner.jsonSocketServer((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"), Optional.empty());
    }

    private static SocketServer jsonSocketServer(Resource resource, Optional<Integer> port) {
        SocketServerParser parser = new SocketServerParser();
        return (SocketServer)parser.parseServer((ImmutableList<InputStream>)ImmutableList.of((Object)MocoJsonRunner.toStream((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null"))), port, new MocoConfig[0]);
    }

    private static HttpServer parseHttpServer(Resource resource, Optional<Integer> port) {
        return (HttpServer)parser.parseServer((ImmutableList<InputStream>)ImmutableList.of((Object)MocoJsonRunner.toStream(resource)), port, new MocoConfig[0]);
    }

    private static InputStream toStream(Resource resource) {
        return ((Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null")).readFor(null).toInputStream();
    }

    private MocoJsonRunner() {
    }
}

