/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.dreamhead.moco.HttpResponseSetting;
import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoMount;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.SocketResponseSetting;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.parser.model.EventSetting;
import com.github.dreamhead.moco.parser.model.MountSetting;
import com.github.dreamhead.moco.parser.model.ProxyContainer;
import com.github.dreamhead.moco.parser.model.RequestSetting;
import com.github.dreamhead.moco.parser.model.ResourceSetting;
import com.github.dreamhead.moco.parser.model.ResponseSetting;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.rest.ActualRestServer;
import com.github.dreamhead.moco.util.Iterables;
import com.google.common.base.MoreObjects;

@JsonIgnoreProperties(value={"description"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class SessionSetting {
    private RequestSetting request;
    private ResponseSetting response;
    private TextContainer redirectTo;
    private MountSetting mount;
    private EventSetting on;
    private ProxyContainer proxy;
    private ResourceSetting resource;

    private boolean isMount() {
        return this.mount != null;
    }

    private boolean isAnyResponse() {
        return this.request == null && this.mount == null && this.proxy == null && this.redirectTo == null && this.resource == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("request", (Object)this.request).add("response", (Object)this.response).add("redirect to", (Object)this.redirectTo).add("mount", (Object)this.mount).add("proxy", (Object)this.proxy).add("on", (Object)this.on).add("resource", (Object)this.resource).toString();
    }

    private boolean isRedirectResponse() {
        return this.redirectTo != null;
    }

    private ResponseHandler getResponseHandler() {
        if (this.response == null) {
            throw new IllegalArgumentException("No response specified");
        }
        return this.response.getResponseHandler();
    }

    private RequestMatcher getRequestMatcher() {
        if (this.request == null) {
            throw new IllegalArgumentException("No request specified");
        }
        return this.request.getRequestMatcher();
    }

    public void bindTo(HttpServer server) {
        HttpResponseSetting setting = this.bindToSession(server);
        if (this.hasEvent()) {
            for (MocoEventTrigger trigger : this.on.triggers()) {
                setting.on(trigger);
            }
        }
    }

    public void bindTo(SocketServer server) {
        if (this.isAnyResponse()) {
            server.response(this.getResponseHandler(), new ResponseHandler[0]);
            return;
        }
        ((SocketResponseSetting)server.request(this.getRequestMatcher())).response(this.getResponseHandler(), new ResponseHandler[0]);
    }

    private HttpResponseSetting bindToSession(HttpServer server) {
        if (this.isMount()) {
            return (HttpResponseSetting)server.mount(this.mount.getDir(), MocoMount.to((String)this.mount.getUri()), this.mount.getMountPredicates()).response(this.mount.getResponseHandler(), new ResponseHandler[0]);
        }
        if (this.isProxy()) {
            if (this.proxy.hasUrl()) {
                throw new IllegalArgumentException("It's not allowed to have URL in proxy from server");
            }
            return server.proxy(this.proxy.getProxyConfig(), this.proxy.getFailover());
        }
        if (this.isAnyResponse()) {
            return (HttpResponseSetting)server.response(this.getResponseHandler(), new ResponseHandler[0]);
        }
        HttpResponseSetting targetRequest = (HttpResponseSetting)server.request(this.getRequestMatcher());
        if (this.isRedirectResponse()) {
            return targetRequest.redirectTo((Resource)this.redirectTo.asResource());
        }
        return (HttpResponseSetting)targetRequest.response(this.getResponseHandler(), new ResponseHandler[0]);
    }

    private boolean isProxy() {
        return this.proxy != null;
    }

    private boolean hasEvent() {
        return this.on != null;
    }

    public boolean isResource() {
        return this.resource != null;
    }

    public ActualHttpServer newHttpServer(int port, MocoConfig[] configs) {
        if (this.isResource()) {
            ActualRestServer server = new ActualRestServer(port, null, Moco.log(), configs);
            Object[] settings = this.resource.getSettings();
            server.resource(this.resource.getName(), (RestSetting)Iterables.head((Object[])settings), (RestSetting[])Iterables.tail((Object[])settings));
            return server;
        }
        ActualHttpServer server = ActualHttpServer.createLogServer((int)port, (MocoConfig[])configs);
        this.bindTo((HttpServer)server);
        return server;
    }

    public boolean isValid() {
        return this.request != null || this.response != null || this.redirectTo != null || this.mount != null || this.on != null || this.proxy != null || this.resource != null;
    }
}

