/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;

public class Spread
extends Transform {
    private final MethodType source;
    private final Class<?>[] spreadTypes;

    public Spread(MethodType source, Class<?> ... spreadTypes) {
        this.source = source;
        this.spreadTypes = spreadTypes;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return target.asSpreader((Class<?>)this.source.parameterType(this.source.parameterCount() - 1), this.spreadTypes.length);
    }

    @Override
    public MethodType down(MethodType type) {
        int last = this.source.parameterCount() - 1;
        if (!this.source.parameterArray()[last].isArray()) {
            throw new InvalidTransformException("trailing argument is not []: " + this.source);
        }
        type = type.dropParameterTypes(last, last + 1);
        return type.appendParameterTypes(this.spreadTypes);
    }

    @Override
    public String toString() {
        return "spread " + this.source + " to " + this.down(this.source);
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder("handle = handle.asSpreader(");
        Spread.buildClassArgument(builder, (Class)this.source.parameterType(this.source.parameterCount() - 1));
        builder.append(", ").append(this.spreadTypes.length);
        builder.append(");");
        return builder.toString();
    }
}

