/*
 * Decompiled with CFR 0.152.
 */
package com.ites.mail.config;

import com.ites.mail.config.MailProperties;
import com.ites.mail.enums.MailTypeEnum;
import com.ites.mail.sender.MailSenderService;
import com.ites.mail.sender.impl.SpringMailSenderServiceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Bean
    public Map<Integer, JavaMailSender> javaMailSenderMap(MailProperties mailProperties) {
        HashMap<Integer, JavaMailSender> mailSenderMap = new HashMap<Integer, JavaMailSender>();
        JavaMailSenderImpl notifySender = new JavaMailSenderImpl();
        this.applyProperties(mailProperties.getNotify(), notifySender);
        mailSenderMap.put(MailTypeEnum.NOTIFY.getType(), (JavaMailSender)notifySender);
        JavaMailSenderImpl marketSender = new JavaMailSenderImpl();
        this.applyProperties(mailProperties.getMarket(), marketSender);
        mailSenderMap.put(MailTypeEnum.MARKET.getType(), (JavaMailSender)marketSender);
        return mailSenderMap;
    }

    @Bean
    public MailSenderService mailSenderService(Map<Integer, JavaMailSender> javaMailSenderMap, MailProperties mailProperties) {
        return new SpringMailSenderServiceImpl(javaMailSenderMap, mailProperties);
    }

    private void applyProperties(MailProperties.Account properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        sender.setProtocol(properties.getProtocol());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (!properties.getProperties().isEmpty()) {
            sender.setJavaMailProperties(this.asProperties(properties.getProperties()));
        }
    }

    private Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }
}

