/*
 * Decompiled with CFR 0.152.
 */
package com.ites.mail.sender.impl;

import cn.hutool.core.util.StrUtil;
import com.ites.mail.attachment.Attachment;
import com.ites.mail.attachment.FileAttachment;
import com.ites.mail.attachment.UrlAttachment;
import com.ites.mail.config.MailProperties;
import com.ites.mail.enums.MailTypeEnum;
import com.ites.mail.exception.MailSenderException;
import com.ites.mail.request.MailSenderRequest;
import com.ites.mail.sender.AbstractMailSenderService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpringMailSenderServiceImpl
extends AbstractMailSenderService {
    private static final Logger log = LoggerFactory.getLogger(SpringMailSenderServiceImpl.class);
    private final Map<Integer, JavaMailSender> javaMailSenderMap;
    private final MailProperties mailProperties;

    @Override
    public boolean send(MailSenderRequest request) {
        this.check(request);
        int mailType = request.getIsMarket() != false ? MailTypeEnum.MARKET.getType() : MailTypeEnum.NOTIFY.getType();
        JavaMailSender javaMailSender = this.javaMailSenderMap.get(mailType);
        MimeMessage message = javaMailSender.createMimeMessage();
        try {
            this.addHeaders(request, message);
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, true);
            this.settingFrom(messageHelper, request);
            messageHelper.setTo(this.buildAddress(request.getTo()));
            messageHelper.setCc(this.buildAddress(request.getCc()));
            this.addAttachment(messageHelper, request.getAttachmentList());
            message.setSubject(request.getSubject());
            messageHelper.setText(request.getText(), request.getIsHtml().booleanValue());
            javaMailSender.send(message);
            log.info("\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
            return true;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean sendHtmlEmail(String email, String subject, String content) {
        MailSenderRequest request = MailSenderRequest.builder().subject(subject).text(content).isMarket(false).to(Collections.singletonList(email)).isHtml(true).build();
        return this.send(request);
    }

    private void settingFrom(MimeMessageHelper messageHelper, MailSenderRequest request) throws Exception {
        MailProperties.Account account;
        MailProperties.Account account2 = account = request.getIsMarket() != false ? this.mailProperties.getMarket() : this.mailProperties.getNotify();
        if (StrUtil.isBlank((CharSequence)account.getFrom())) {
            throw new MailSenderException("\u90ae\u4ef6\u53d1\u9001\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fromEmail = account.getFrom();
        String fromPersonal = account.getFromPersonal();
        if (StringUtils.hasText((String)fromPersonal)) {
            messageHelper.setFrom(fromEmail, fromPersonal);
        }
    }

    private void addAttachment(MimeMessageHelper messageHelper, List<Attachment> attachmentList) throws MalformedURLException, MessagingException {
        if (CollectionUtils.isEmpty(attachmentList)) {
            return;
        }
        for (Attachment attachment : attachmentList) {
            String name = attachment.getName();
            Object data = attachment.getData();
            Assert.isTrue((boolean)StringUtils.hasText((String)name), (String)"\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)Objects.nonNull(data), (String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            if (attachment instanceof FileAttachment) {
                messageHelper.addAttachment(name, (File)data);
            }
            if (!(attachment instanceof UrlAttachment)) continue;
            messageHelper.addAttachment(name, (DataSource)new URLDataSource(new URL(data.toString())));
        }
    }

    private InternetAddress[] buildAddress(List<String> toList) {
        if (CollectionUtils.isEmpty(toList)) {
            return new InternetAddress[0];
        }
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        try {
            for (String to : toList) {
                list.add(new InternetAddress(to));
            }
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new InternetAddress[0]);
    }

    public SpringMailSenderServiceImpl(Map<Integer, JavaMailSender> javaMailSenderMap, MailProperties mailProperties) {
        this.javaMailSenderMap = javaMailSenderMap;
        this.mailProperties = mailProperties;
    }
}

