package com.ites.mail.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author liutao
 * @since 2025/1/8
 */
@Data
@ConfigurationProperties(prefix = "ites.mail")
public class MailProperties {

    private Account notify;

    private Account market;



    @Data
    public static class Account {

        private String host;

        private String username;

        private String password;

        private String protocol = "smtp";

        private Integer port;

        private String from;

        private String fromPersonal;

        private Charset defaultEncoding = StandardCharsets.UTF_8;

        private Map<String, String> properties = new HashMap<>();

    }
}
