package com.ites.mail.request;

import com.ites.mail.attachment.Attachment;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author liutao
 * @since 2023/8/30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MailSenderRequest implements Serializable {

    /**
     * 发送人
     */
    private String from;
    /**
     * 发送人姓名
     */
    private String fromPersonal;
    /**
     * 回复人
     */
    private String replyTo;
    /**
     * 收件人
     */
    private List<String> to;
    /**
     * 抄送人
     */
    private List<String> cc;
    /**
     * 密送人
     */
    private List<String> bcc;
    /**
     * 发送时间
     */
    private LocalDateTime sendDate;
    /**
     * 主题
     */
    private String subject;
    /**
     * 正文
     */
    private String text;
    /**
     * 是否是html
     */
    private Boolean isHtml;
    /**
     * 附件
     */
    private List<Attachment> attachmentList;
    /**
     * 是否是营销
     */
    private Boolean isMarket;
    /**
     * 业务id
     */
    private Integer businessId;
    /**
     * 任务名称
     */
    private String taskName;
}
