/*
 * Decompiled with CFR 0.152.
 */
package com.ites.mail.sender.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.ites.mail.attachment.Attachment;
import com.ites.mail.attachment.FileAttachment;
import com.ites.mail.attachment.UrlAttachment;
import com.ites.mail.config.MailProperties;
import com.ites.mail.enums.MailTypeEnum;
import com.ites.mail.exception.MailSenderException;
import com.ites.mail.request.MailSenderRequest;
import com.ites.mail.sender.AbstractMailSenderService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpringMailSenderServiceImpl
extends AbstractMailSenderService {
    private static final Logger log = LoggerFactory.getLogger(SpringMailSenderServiceImpl.class);
    private final Map<Integer, JavaMailSender> javaMailSenderMap;
    private final MailProperties mailProperties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final DefaultRedisScript<String> checkEmailSendCountScript;
    private final DefaultRedisScript<Long> batchAddEmailSendCountScript;

    public SpringMailSenderServiceImpl(Map<Integer, JavaMailSender> javaMailSenderMap, MailProperties mailProperties, RedisTemplate<String, Object> redisTemplate) {
        this.javaMailSenderMap = javaMailSenderMap;
        this.mailProperties = mailProperties;
        this.redisTemplate = redisTemplate;
        this.batchAddEmailSendCountScript = new DefaultRedisScript();
        this.batchAddEmailSendCountScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("lua/batch_add_email_send_count.lua")));
        this.batchAddEmailSendCountScript.setResultType(Long.class);
        this.checkEmailSendCountScript = new DefaultRedisScript();
        this.checkEmailSendCountScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("lua/check_email_send_count.lua")));
        this.checkEmailSendCountScript.setResultType(String.class);
    }

    @Override
    public boolean send(MailSenderRequest request) {
        this.check(request);
        List<String> excludes = this.filterOverSendCountEmail(request);
        log.info("\u8fbe\u5230\u53d1\u9001\u6b21\u6570\u90ae\u7bb1\uff1a{}", excludes);
        if (CollectionUtils.isEmpty(request.getTo())) {
            return true;
        }
        int mailType = request.getIsMarket() != false ? MailTypeEnum.MARKET.getType() : MailTypeEnum.NOTIFY.getType();
        JavaMailSender javaMailSender = this.javaMailSenderMap.get(mailType);
        MimeMessage message = javaMailSender.createMimeMessage();
        try {
            this.addHeaders(request, message);
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, true);
            this.settingFrom(messageHelper, request);
            messageHelper.setTo(this.buildAddress(request.getTo()));
            messageHelper.setCc(this.buildAddress(request.getCc()));
            this.addAttachment(messageHelper, request.getAttachmentList());
            message.setSubject(request.getSubject());
            messageHelper.setText(request.getText(), request.getIsHtml().booleanValue());
            javaMailSender.send(message);
            this.batchAddMobileSendCount(request.getTo());
            log.info("\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
            return true;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
    }

    private List<String> filterOverSendCountEmail(MailSenderRequest request) {
        List<String> to = request.getTo();
        String mobilesStr = String.join((CharSequence)",", to);
        long expireSeconds = LocalDateTimeUtil.between((LocalDateTime)LocalDateTime.now(), (LocalDateTime)LocalDateTime.now().withHour(23).withMinute(59).withSecond(59), (ChronoUnit)ChronoUnit.SECONDS);
        String result = (String)this.redisTemplate.execute(this.checkEmailSendCountScript, Collections.singletonList("email:send:count"), new Object[]{2, mobilesStr, expireSeconds});
        if (result != null && !result.isEmpty()) {
            List<String> excludes = Arrays.asList(result.split(","));
            to.removeIf(excludes::contains);
            request.setTo(to);
            return excludes;
        }
        return Collections.emptyList();
    }

    private void batchAddMobileSendCount(List<String> mobiles) {
        String mobilesStr = String.join((CharSequence)",", mobiles);
        this.redisTemplate.execute(this.batchAddEmailSendCountScript, Collections.singletonList("email:send:count"), new Object[]{mobilesStr});
    }

    @Override
    public boolean sendHtmlEmail(String email, String subject, String content) {
        MailSenderRequest request = MailSenderRequest.builder().subject(subject).text(content).isMarket(false).to(Collections.singletonList(email)).isHtml(true).build();
        return this.send(request);
    }

    private void settingFrom(MimeMessageHelper messageHelper, MailSenderRequest request) throws Exception {
        MailProperties.Account account;
        MailProperties.Account account2 = account = request.getIsMarket() != false ? this.mailProperties.getMarket() : this.mailProperties.getNotify();
        if (StrUtil.isBlank((CharSequence)account.getFrom())) {
            throw new MailSenderException("\u90ae\u4ef6\u53d1\u9001\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fromEmail = account.getFrom();
        String fromPersonal = account.getFromPersonal();
        if (StringUtils.hasText((String)fromPersonal)) {
            messageHelper.setFrom(fromEmail, fromPersonal);
        }
    }

    private void addAttachment(MimeMessageHelper messageHelper, List<Attachment> attachmentList) throws MalformedURLException, MessagingException {
        if (CollectionUtils.isEmpty(attachmentList)) {
            return;
        }
        for (Attachment attachment : attachmentList) {
            String name = attachment.getName();
            Object data = attachment.getData();
            Assert.isTrue((boolean)StringUtils.hasText((String)name), (String)"\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)Objects.nonNull(data), (String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            if (attachment instanceof FileAttachment) {
                messageHelper.addAttachment(name, (File)data);
            }
            if (!(attachment instanceof UrlAttachment)) continue;
            messageHelper.addAttachment(name, (DataSource)new URLDataSource(new URL(data.toString())));
        }
    }

    private InternetAddress[] buildAddress(List<String> toList) {
        if (CollectionUtils.isEmpty(toList)) {
            return new InternetAddress[0];
        }
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        try {
            for (String to : toList) {
                list.add(new InternetAddress(to));
            }
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new InternetAddress[0]);
    }
}

