/*
 * Decompiled with CFR 0.152.
 */
package com.ites.mail.sender;

import cn.hutool.core.util.BooleanUtil;
import com.ites.mail.exception.MailSenderException;
import com.ites.mail.request.MailSenderRequest;
import com.ites.mail.sender.MailSenderService;
import com.ites.mail.util.EmailValidateUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMailSenderService
implements MailSenderService {
    protected void check(MailSenderRequest request) {
        this.check(request.getTo(), request.getSubject(), request.getText());
    }

    protected void check(List<String> to, String subject, String text) {
        if (CollectionUtils.isEmpty(to)) {
            throw new MailSenderException("\u90ae\u4ef6\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List errorEmails = to.stream().filter(EmailValidateUtil::isNotEmail).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(errorEmails)) {
            throw new MailSenderException("\u90ae\u4ef6\u63a5\u6536\u4eba\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + String.join((CharSequence)",", errorEmails));
        }
        if (!StringUtils.hasText((String)subject)) {
            throw new MailSenderException("\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)text)) {
            throw new MailSenderException("\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void addHeaders(MailSenderRequest request, MimeMessage message) throws Exception {
        if (BooleanUtil.isTrue((Boolean)request.getIsMarket())) {
            message.addHeader("X-Qos", "bulk");
        }
        message.addHeader("X-List", MimeUtility.encodeText((String)(request.getTaskName() == null ? "singleSend" : request.getTaskName())));
        message.addHeader("X-Campaign", MimeUtility.encodeText((String)request.getSubject()));
        message.addHeader("X-Tracking-ID", MimeUtility.encodeText((String)(request.getBusinessId() == null ? "0" : String.valueOf(request.getBusinessId()))));
        message.addHeader("X-Tracking-Data", MimeUtility.encodeText((String)(request.getBusinessId() == null ? "0" : String.valueOf(request.getBusinessId()))));
    }
}

