package com.ites.mail.sender;

import com.ites.mail.request.MailSenderRequest;

/**
 * @author liutao
 * @since 2023/8/30
 */
public interface MailSenderService {


    /**
     * 邮件发送
     * @param request {@link com.ites.mail.request.MailSenderRequest}
     * @return true false
     */
    boolean send(MailSenderRequest request);

    /**
     * 发送html邮件
     * @param email 收件人
     * @param subject 主题
     * @param content 内容
     * @return true false
     */
    boolean sendHtmlEmail(String email, String subject, String content);
}
