/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.backup.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.common.valid.interfaces.Update;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.sms.manager.SmsManager;
import com.ites.web.sms.session.SmsSession;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.IPUtil;
import com.ites.web.utils.NumberUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.entity.VisitRegistInfoExtend;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.vo.VisitRegistInfoVO;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.export.SmsServiceExport;
import com.simm.publicservice.export.WebPowerEmailServiceExport;
import com.simm.publicservice.pojo.Resp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89c2\u4f17\u767b\u8bb0 API"})
public class BackupVisitRegistInfoController
extends BaseController {
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private VisitRegistNoService visitRegistNoService;
    @Resource
    private BasicUserService basicUserService;
    @Resource
    private SmsManager smsManager;
    @Reference
    private SmsServiceExport smsServiceExport;
    @Reference
    private WebPowerEmailServiceExport webPowerEmailServiceExport;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    public Result sendCode(@PathVariable(value="mobile") String mobile) {
        SmsSession session = new SmsSession();
        String redisKey = "web_" + mobile;
        session.setSendTime(LocalDateTime.now());
        String code = NumberUtil.randomNumber((int)6);
        String content = code + "\uff08\u9a8c\u8bc1\u7801\u5341\u5206\u949f\u6709\u6548\uff09\u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011";
        Resp smsResp = this.smsServiceExport.sendCode(mobile, content);
        if (!"200".equals(smsResp.getCode())) {
            return R.failure((String)"5001");
        }
        session.setCode(code);
        session.setCheck(false);
        this.redisManager.set(redisKey, (Object)session, 14400L);
        return R.ok();
    }

    @GetMapping
    @ExculdeWxSecurity
    @CommonController(description="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u9884\u767b\u8bb0")
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u9884\u767b\u8bb0", httpMethod="GET")
    public Result<VisitRegistInfoVO> findByMobile(@PathVariable(value="mobile") String mobile, @PathVariable(value="code") String code) {
        boolean validation = this.smsManager.validation(mobile, code);
        boolean superCode = code.equals("aaaa");
        if (!validation && !superCode) {
            return R.failure((String)"5002");
        }
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByMobile(mobile);
        VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class);
        if (ObjectUtils.isNotEmpty((Object)vo)) {
            vo.setIsPreSuccess(Boolean.valueOf(!StringUtils.isBlank((CharSequence)vo.getSmsStatus())));
        }
        return R.ok((Object)vo);
    }

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u4fdd\u5b58\u89c2\u4f17\u9884\u767b\u8bb0\u4fe1\u606f", httpMethod="POST")
    public Result insert(@RequestBody @Validated(value={Insert.class}) VisitRegistInfoExtend visitRegistInfo) {
        boolean result;
        Resp resp;
        VisitRegistInfo info = this.visitRegistInfoService.findByMobile(visitRegistInfo.getMobile());
        if (ObjectUtils.isNotEmpty((Object)info)) {
            return R.ok((Object)info);
        }
        if (WebConstant.IDENTITY_CARD_TYPE.equals(visitRegistInfo.getIdentityCardType()) && !"200".equals((resp = this.identityCardServiceExport.identityCard(visitRegistInfo.getIdentityCard(), visitRegistInfo.getName())).getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfo);
        String ip = IPUtil.getIP((HttpServletRequest)this.request);
        visitRegistInfo.setIp(ip);
        visitRegistInfo.setNumbers(WebConstant.NUMBER);
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN);
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            return R.failure();
        }
        visitRegistInfo.setCardNo(cardNo);
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getSpecial()) && visitRegistInfo.getSpecial().booleanValue()) {
            visitRegistInfo.setOrderStatus(WebConstant.WX_PAID);
        }
        if (result = this.visitRegistInfoService.save((Object)visitRegistInfo)) {
            return R.ok((Object)visitRegistInfo);
        }
        return R.failure();
    }

    @PostMapping
    @ExculdeWxSecurity
    @CommonController(description="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f")
    @ApiOperation(value="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f", httpMethod="POST")
    public Result submitQuestion(@RequestBody @Validated(value={Update.class}) VisitRegistInfo visitRegist) {
        VisitRegistInfo visitRegistDB = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)visitRegist.getId());
        visitRegistDB.setQuestion(visitRegist.getQuestion());
        visitRegistDB.setSmsStatus("SMSOK");
        visitRegistDB.setSync(Boolean.valueOf(false));
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegistDB);
        boolean result = this.visitRegistInfoService.updateById((Object)visitRegistDB);
        this.visitRegistInfoService.sendMailAndMessage(visitRegistDB);
        if (result) {
            VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistDB, VisitRegistInfoVO.class);
            vo.setIsPreSuccess(Boolean.valueOf(!StringUtils.isBlank((CharSequence)visitRegistDB.getSmsStatus())));
            return R.ok((Object)vo);
        }
        return R.failure();
    }
}

