/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.basic.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ites.web.basic.entity.BasicArea;
import com.ites.web.basic.entity.BasicCity;
import com.ites.web.basic.entity.BasicCountry;
import com.ites.web.basic.entity.BasicProvince;
import com.ites.web.basic.service.BasicAreaService;
import com.ites.web.basic.service.BasicCityService;
import com.ites.web.basic.service.BasicCountryService;
import com.ites.web.basic.service.BasicProvinceService;
import com.ites.web.basic.vo.BasicCountryVO;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.vo.BaseVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fd\u5bb6\u57fa\u672c\u4fe1\u606f\u8868 API"})
public class BasicCountryController
extends BaseController {
    @Resource
    private BasicCountryService basicCountryService;
    @Resource
    private BasicProvinceService basicProvinceService;
    @Resource
    private BasicCityService basicCityService;
    @Resource
    private BasicAreaService basicAreaService;

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="GET")
    public Result<List<BasicCountryVO>> findList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.basicCountryService.list((Wrapper)queryWrapper);
        List vos = BaseVO.conversion((List)list, BasicCountryVO.class);
        return R.ok((Object)vos);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="GET")
    public Result<List<BasicCountry>> findListAll() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.basicCountryService.list((Wrapper)queryWrapper);
        BasicCountry basicCountry = (BasicCountry)list.get(0);
        List provinces = this.basicProvinceService.list();
        basicCountry.setProvinces(provinces);
        for (BasicProvince province : provinces) {
            LambdaQueryWrapper basicCityLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicCity::getPid, (Object)province.getId());
            List citys = this.basicCityService.list((Wrapper)basicCityLambdaQueryWrapper);
            province.setCitys(citys);
            for (BasicCity city : citys) {
                LambdaQueryWrapper basicAreaLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicArea::getPid, (Object)city.getId());
                List areas = this.basicAreaService.list((Wrapper)basicAreaLambdaQueryWrapper);
                city.setAreas(areas);
            }
        }
        return R.ok((Object)list);
    }
}

