/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.basic.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.basic.dao.BasicUserDao;
import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.session.MySession;
import com.ites.web.utils.DateUtil;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.JwtUtil;
import com.joneying.web.redis.RedisManager;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="basicUserService")
public class BasicUserServiceImpl
extends ServiceImpl<BasicUserDao, BasicUser>
implements BasicUserService {
    private static final Logger log = LoggerFactory.getLogger(BasicUserServiceImpl.class);
    @Autowired
    private WxMpService wxService;
    @Resource
    private RedisManager redisManager;
    @Resource
    private HttpServletResponse response;
    @Resource
    private HttpServletRequest request;

    public BasicUser findByOpenId(String openId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicUser::getOpenId, (Object)openId);
        queryWrapper.orderByDesc(BasicUser::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (BasicUser)list.get(0);
    }

    public BasicUser findByUnionId(String unionid) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicUser::getUnionid, (Object)unionid);
        queryWrapper.orderByDesc(BasicUser::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (BasicUser)list.get(0);
    }

    public List<BasicUser> findListByUnionId(String unionid) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicUser::getUnionid, (Object)unionid);
        queryWrapper.orderByDesc(BasicUser::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    public BasicUser findByOpenIdAndUnionId(String openId, String unionId) {
        BasicUser user = this.findByOpenId(openId);
        if (ObjectUtils.isEmpty((Object)user) && StringUtils.isNotBlank((CharSequence)unionId)) {
            user = this.findByUnionId(unionId);
        }
        return user;
    }

    public BasicUser findByMobile(String mobile) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasicUser::getMobile, (Object)mobile);
        queryWrapper.orderByDesc(BasicUser::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (BasicUser)list.get(0);
    }

    public void login(String mobile) {
        BasicUser basicUser = this.findByMobile(mobile);
        if (ObjectUtils.isEmpty((Object)basicUser)) {
            basicUser = new BasicUser();
            basicUser.setMobile(mobile);
            basicUser.setRemark("web");
            EntityDateUtil.supplementInsert((BaseEntity)basicUser);
            this.save((Object)basicUser);
        }
        this.initSession(basicUser);
    }

    public void login(String openId, String unionId) throws WxErrorException {
        log.info("===================================>openId:" + openId);
        BasicUser basicUser = this.findByOpenIdAndUnionId(openId, unionId);
        WxMpUser wxMpUser = this.wxService.getUserService().userInfo(openId);
        log.info("wxMpUser" + wxMpUser.toString());
        if (ObjectUtils.isEmpty((Object)basicUser)) {
            basicUser = new BasicUser();
            basicUser.setOpenId(openId);
            basicUser.setUnionid(wxMpUser.getUnionId());
            basicUser.setNickname(wxMpUser.getNickname());
            basicUser.setAvatarUrl(wxMpUser.getHeadImgUrl());
            basicUser.setRemark("web");
            EntityDateUtil.supplementInsert((BaseEntity)basicUser);
            this.save((Object)basicUser);
        } else if (!StringUtils.equals((CharSequence)basicUser.getUnionid(), (CharSequence)wxMpUser.getUnionId()) || !StringUtils.equals((CharSequence)basicUser.getOpenId(), (CharSequence)openId)) {
            log.info("basicUser.toString() {}", (Object)basicUser.toString());
            basicUser.setOpenId(openId);
            basicUser.setUnionid(wxMpUser.getUnionId());
            basicUser.setAvatarUrl(wxMpUser.getHeadImgUrl());
            basicUser.setNickname(wxMpUser.getNickname());
            EntityDateUtil.supplementUpdate((BaseEntity)basicUser);
            this.updateById((Object)basicUser);
        }
        this.initSession(basicUser);
    }

    private void initSession(BasicUser basicUser) {
        String token = JwtUtil.generateToken((long)basicUser.getId().intValue());
        MySession session = MySession.buildSession((BasicUser)basicUser);
        this.redisManager.set(token, (Object)session, 14400L);
        MyContext.session((MySession)session);
        this.refreshToken(token);
    }

    public void refreshSession(MySession session) {
        String token = this.request.getHeader("Access-Token");
        this.redisManager.set(token, (Object)session, 14400L);
        MyContext.session((MySession)session);
        this.refreshToken(token);
    }

    public void unsubscribleMp(String openId) {
        BasicUser basicUser = this.selectByMpOpenId(openId);
        if (basicUser == null) {
            return;
        }
        basicUser.setSubscribleFlag(Boolean.valueOf(false));
        ((BasicUserDao)this.baseMapper).updateById((Object)basicUser);
    }

    private BasicUser selectByMpOpenId(String openId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BasicUser::getMpOpenId, (Object)openId);
        List list = ((BasicUserDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        BasicUser basicUser = (BasicUser)list.get(0);
        return basicUser;
    }

    public void refreshToken(String token) {
        this.response.setHeader("Access-Control-Expose-Headers", "Access-Token,Token-Expire");
        this.response.setHeader("Access-Token", token);
        this.response.setHeader("Token-Expire", DateUtil.localDateTimeToString((LocalDateTime)LocalDateTime.now().plusSeconds(14400L)));
    }
}

