/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.captcha.controller;

import com.ites.web.captcha.dto.ImageVerificationDto;
import com.ites.web.captcha.exception.ServiceException;
import com.ites.web.captcha.manager.CaptchaManager;
import com.ites.web.captcha.vo.ImageVerificationVO;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.valid.interfaces.Insert;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6ed1\u52a8\u9a8c\u8bc1\u7801 API"})
public class CaptchaController
extends BaseController {
    @Resource
    private CaptchaManager captchaManager;

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u6ed1\u52a8\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u6ed1\u52a8\u9a8c\u8bc1\u7801")
    public Result<ImageVerificationVO> generateVerifyImg() {
        try {
            ImageVerificationDto imageVerificationDto = this.captchaManager.selectImageVerificationCode(null);
            ImageVerificationVO vo = new ImageVerificationVO();
            BeanUtils.copyProperties((Object)imageVerificationDto, (Object)vo);
            return R.ok((Object)vo);
        }
        catch (ServiceException e) {
            return R.failure((String)e.getCode(), (String)e.getMessage());
        }
    }

    @PostMapping
    @ApiOperation(value="\u6821\u9a8c\u9a8c\u8bc1\u7801", notes="\u6821\u9a8c\u9a8c\u8bc1\u7801")
    public Result checkVerificationResult(@RequestBody @Validated(value={Insert.class}) ImageVerificationDto imageVerificationDto) {
        try {
            boolean result = this.captchaManager.checkVerificationResult(imageVerificationDto);
            return R.ok((Object)result);
        }
        catch (ServiceException e) {
            return R.failure((String)e.getCode(), (String)e.getMessage());
        }
    }
}

