/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.captcha.manager;

import com.google.code.kaptcha.Producer;
import com.ites.web.captcha.dto.ImageVerificationDto;
import com.ites.web.captcha.enums.VerificationCodeType;
import com.ites.web.captcha.exception.ServiceException;
import com.ites.web.captcha.exception.ServiceExceptionCode;
import com.ites.web.captcha.manager.CaptchaManager;
import com.ites.web.utils.ImageVerificationUtil;
import com.joneying.web.redis.RedisManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.util.ObjectUtils;

@Component
public class CaptchaManager {
    private static final Logger log = LoggerFactory.getLogger(CaptchaManager.class);
    @Resource
    private RedisManager redisManager;
    @Resource
    private Producer captchaProducer;
    @Autowired
    private Producer captchaProducerMath;
    @Value(value="${captcha.path.template}")
    private String captchaTemplate;
    @Value(value="${captcha.path.border}")
    private String captchaBorder;
    @Value(value="${captcha.path.target}")
    private String captchaTarget;

    public ImageVerificationDto selectImageVerificationCode(String type) throws ServiceException {
        ImageVerificationDto imageVerificationDto;
        try {
            if (ObjectUtils.isEmpty((Object)type)) {
                type = VerificationCodeType.SLIDE.name();
            }
            VerificationCodeType verificationCodeType = Enum.valueOf(VerificationCodeType.class, type.toUpperCase());
            switch (1.$SwitchMap$com$ites$web$captcha$enums$VerificationCodeType[verificationCodeType.ordinal()]) {
                case 1: {
                    imageVerificationDto = this.selectOperationVerificationCode();
                    break;
                }
                case 2: {
                    imageVerificationDto = this.selectCharVerificationCode();
                    break;
                }
                case 3: {
                    imageVerificationDto = this.selectSlideVerificationCode();
                    break;
                }
                default: {
                    throw new ServiceException(ServiceExceptionCode.SELECT_VERIFICATION_CODE_ERROR);
                }
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.SELECT_VERIFICATION_CODE_ERROR);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.SELECT_VERIFICATION_CODE_ERROR);
        }
        return imageVerificationDto;
    }

    private ImageVerificationDto selectOperationVerificationCode() throws ServiceException {
        byte[] bytes = null;
        String text = "";
        BufferedImage bufferedImage = null;
        ImageVerificationDto imageVerificationDto = new ImageVerificationDto();
        try {
            imageVerificationDto.setType(imageVerificationDto.getType());
            text = this.captchaProducerMath.createText();
            String value = text.substring(0, text.lastIndexOf("@"));
            bufferedImage = this.captchaProducerMath.createImage(value);
            String verifyId = UUID.randomUUID().toString();
            imageVerificationDto.setVerifyId(verifyId);
            this.redisManager.set("verify_" + verifyId, (Object)imageVerificationDto);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            bytes = byteArrayOutputStream.toByteArray();
            imageVerificationDto.setOperationImage(Base64Utils.encodeToString((byte[])bytes));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.SELECT_VERIFICATION_CODE_ERROR);
        }
        return imageVerificationDto;
    }

    private ImageVerificationDto selectCharVerificationCode() throws ServiceException {
        ImageVerificationDto imageVerificationDto;
        try {
            imageVerificationDto = new ImageVerificationDto();
            String text = this.captchaProducer.createText();
            BufferedImage bufferedImage = this.captchaProducer.createImage(text);
            String verifyId = UUID.randomUUID().toString();
            imageVerificationDto.setVerifyId(verifyId);
            this.redisManager.set("verify_" + verifyId, (Object)imageVerificationDto);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            imageVerificationDto.setCharImage(Base64Utils.encodeToString((byte[])bytes));
            imageVerificationDto.setType(imageVerificationDto.getType() == null ? "char" : imageVerificationDto.getType());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.SELECT_VERIFICATION_CODE_ERROR);
        }
        return imageVerificationDto;
    }

    public ImageVerificationDto selectSlideVerificationCode() throws ServiceException {
        ImageVerificationDto imageVerificationDto = null;
        try {
            File verifyImageImport = new File(this.captchaTarget);
            File[] verifyImages = verifyImageImport.listFiles();
            Random random = new Random(System.currentTimeMillis());
            int _random = random.nextInt(verifyImages.length);
            log.debug("CaptchaManager-------->selectSlideVerificationCode-------->random:" + _random);
            File originImageFile = verifyImages[1];
            File templateImageFile = new File(this.captchaTemplate);
            File borderImageFile = new File(this.captchaBorder);
            String borderImageFileType = borderImageFile.getName().substring(borderImageFile.getName().lastIndexOf(".") + 1);
            String originImageFileType = originImageFile.getName().substring(originImageFile.getName().lastIndexOf(".") + 1);
            String templateImageFileType = templateImageFile.getName().substring(templateImageFile.getName().lastIndexOf(".") + 1);
            BufferedImage verificationImage = ImageIO.read(originImageFile);
            BufferedImage readTemplateImage = ImageIO.read(templateImageFile);
            BufferedImage borderImage = ImageIO.read(borderImageFile);
            imageVerificationDto = ImageVerificationUtil.generateCutoutCoordinates((BufferedImage)verificationImage, (BufferedImage)readTemplateImage);
            String verifyId = UUID.randomUUID().toString();
            this.redisManager.set("verify_" + verifyId, (Object)imageVerificationDto);
            int y = imageVerificationDto.getY();
            imageVerificationDto = ImageVerificationUtil.pictureTemplateCutout((File)originImageFile, (String)originImageFileType, (File)templateImageFile, (String)templateImageFileType, (int)imageVerificationDto.getX(), (int)imageVerificationDto.getY());
            imageVerificationDto = ImageVerificationUtil.cutoutImageEdge((ImageVerificationDto)imageVerificationDto, (BufferedImage)borderImage, (String)borderImageFileType);
            imageVerificationDto.setY(y);
            imageVerificationDto.setType(imageVerificationDto.getType());
            imageVerificationDto.setVerifyId(verifyId);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.URL_DECODER_ERROR);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
        }
        return imageVerificationDto;
    }

    public boolean checkVerificationResult(ImageVerificationDto imageVerificationDto) throws ServiceException {
        int threshold = 5;
        try {
            ImageVerificationDto imageVerificationDb = (ImageVerificationDto)this.redisManager.get("verify_" + imageVerificationDto.getVerifyId());
            if (imageVerificationDb != null) {
                return Math.abs(imageVerificationDto.getX() - imageVerificationDb.getX()) <= threshold;
            }
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
        }
    }
}

