/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.common.handler;

import com.ites.web.common.handler.ServiceException;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(annotations={RestController.class})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public com.baomidou.mybatisplus.extension.api.R runtimeExceptionHandler(Exception e) {
        log.error("\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a: {}", (Throwable)e);
        return com.baomidou.mybatisplus.extension.api.R.failed((String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public com.baomidou.mybatisplus.extension.api.R handleBindException(MethodArgumentNotValidException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:{}({})", (Object)fieldError.getDefaultMessage(), (Object)fieldError.getField());
        return com.baomidou.mybatisplus.extension.api.R.failed((String)fieldError.getDefaultMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public com.baomidou.mybatisplus.extension.api.R handleBindException(BindException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:{}({})", (Object)fieldError.getDefaultMessage(), (Object)fieldError.getField());
        return com.baomidou.mybatisplus.extension.api.R.failed((String)fieldError.getDefaultMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public Result<?> serviceException(ServiceException e) {
        log.error("\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        return R.failure((String)e.getCode());
    }
}

