/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.common.interceptor;

import com.ites.web.common.context.MyContext;
import com.ites.web.common.session.MySession;
import com.ites.web.utils.IPUtil;
import com.joneying.web.redis.RedisManager;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MyContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MyContextInterceptor.class);
    @Resource
    private RedisManager redisManager;
    @Resource
    private HttpServletRequest request;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader("Access-Token");
        String ip = IPUtil.getIP((HttpServletRequest)request);
        log.info(LocalDateTime.now() + "{}===========>preHandle============>Token=============>{}", (Object)ip, (Object)token);
        log.debug(System.currentTimeMillis() + "{}===========>preHandle============>Token=============>{}", (Object)ip, (Object)token);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Object obj = this.redisManager.get(token);
            MyContext.session((MySession)((MySession)obj));
            request.setAttribute("Access-Token", (Object)((MySession)obj));
        } else {
            MyContext.session(null);
        }
        if (ObjectUtils.isNotEmpty((Object)MyContext.session())) {
            log.debug("Session=================================>{}", (Object)MyContext.session().toString());
        }
        return true;
    }
}

