/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.download.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.download.entity.WebDownload;
import com.ites.web.download.entity.WebDownloadLog;
import com.ites.web.download.service.WebDownloadLogService;
import com.ites.web.download.service.WebDownloadService;
import com.ites.web.download.vo.WebDownloadVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u6599\u4e0b\u8f7d\u8868 API"})
public class WebDownloadController
extends BaseController {
    @Resource
    private WebDownloadService webDownloadService;
    @Autowired
    private WebDownloadLogService webDownloadLogService;

    @PostMapping
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u8f7d\u8d44\u6599\u5217\u8868", httpMethod="POST")
    public Result<List<WebDownloadVO>> findList(@RequestBody WebDownload webDownload) {
        webDownload.setLanguage(Integer.valueOf(this.getLanguage()));
        webDownload.setIsOnline(Boolean.TRUE);
        LambdaQueryWrapper webDownloadLambdaQueryWrapper = new LambdaQueryWrapper((Object)webDownload);
        webDownloadLambdaQueryWrapper.orderByDesc(WebDownload::getCreateBy);
        List webDownloads = this.webDownloadService.list((Wrapper)webDownloadLambdaQueryWrapper);
        List webDownloadVOS = BaseVO.conversion((List)webDownloads, WebDownloadVO.class);
        return R.ok((Object)webDownloadVOS);
    }

    @GetMapping
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6URL", httpMethod="GET")
    public Result findURLById(@PathVariable(value="id") Integer id) {
        WebDownload webDownload = (WebDownload)this.webDownloadService.getById((Serializable)id);
        if (!webDownload.getIsWrite().booleanValue()) {
            return R.ok((Object)webDownload.getFileUrl());
        }
        if (!MyContext.isLogin() || StringUtils.isBlank((CharSequence)MyContext.session().getName())) {
            return R.ok();
        }
        WebDownloadLog log = new WebDownloadLog();
        log.setUserId(MyContext.userId());
        log.setDownloadId(id);
        log.setCreateTime(LocalDateTime.now());
        this.webDownloadLogService.save((Object)log);
        return R.ok((Object)webDownload.getFileUrl());
    }
}

