/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.home.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import com.ites.web.basic.entity.WebSearchLog;
import com.ites.web.basic.service.WebSearchLogService;
import com.ites.web.basic.vo.WebSearchLogVO;
import com.ites.web.basic.vo.WebSearchVO;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.exhibitor.vo.ExhibitorInfoVO;
import com.ites.web.media.entity.WebNews;
import com.ites.web.media.service.WebNewsService;
import com.ites.web.media.vo.WebNewsVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.logger.annotation.TrackLog;
import com.joneying.web.logger.enums.ActionType;
import com.joneying.web.logger.enums.BhvType;
import com.joneying.web.logger.enums.ObjType;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.exhibitor.bean.basic.SmebExhibitorInfo;
import com.simm.exhibitor.export.SmebExhibitorInfoServiceExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5b98\u7f51\u641c\u7d22"})
public class WebSearchController
extends BaseController {
    @Resource
    private WebNewsService webNewsService;
    @Resource
    private WebSearchLogService webSearchLogService;
    @Reference
    private SmebExhibitorInfoServiceExport smebExhibitorInfoServiceExport;

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u70ed\u95e8\u5173\u952e\u8bcd", httpMethod="GET")
    public Result findHotKeyword() {
        WebSearchLog webSearchLog = new WebSearchLog();
        webSearchLog.setLanguage(Integer.valueOf(this.getLanguage()));
        webSearchLog.setPageSize(Integer.valueOf(6));
        Page page = this.webSearchLogService.findPage(webSearchLog);
        Page vos = BaseVO.conversion((Page)page, WebSearchLogVO.class);
        return R.ok((Object)vos);
    }

    @GetMapping
    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u641c\u7d22", httpMethod="GET")
    @TrackLog(action=ActionType.BEHAVIOR, bhvType=BhvType.GLOBAL_SEARCH, objType=ObjType.UNKNOWN)
    public Result findListByKeyword(@PathVariable(value="keyword") String keyword) {
        int language = this.getLanguage();
        this.webSearchLogService.addCount(keyword, Integer.valueOf(language));
        WebSearchVO vo = new WebSearchVO();
        WebNews webNews = new WebNews();
        webNews.setSearchKey(keyword);
        webNews.setLanguage(Integer.valueOf(language));
        Page newsPage = this.webNewsService.findPage(webNews);
        Page newsPageVo = BaseVO.conversion((Page)newsPage, WebNewsVO.class);
        vo.setNewVos(newsPageVo);
        SmebExhibitorInfo exhibitorInfo = new SmebExhibitorInfo();
        exhibitorInfo.setSearchKey(keyword);
        exhibitorInfo.setNumber(WebConstant.NUMBER);
        PageInfo exhibitorInfoPage = this.smebExhibitorInfoServiceExport.findPageByKeyWord(exhibitorInfo);
        ArrayList<ExhibitorInfoVO> vos = new ArrayList<ExhibitorInfoVO>();
        for (SmebExhibitorInfo info : exhibitorInfoPage.getList()) {
            ExhibitorInfoVO exhibitorInfoVo = new ExhibitorInfoVO();
            BeanUtils.copyProperties((Object)info, (Object)exhibitorInfoVo);
            this.beautifyData(info, exhibitorInfoVo);
            vos.add(exhibitorInfoVo);
        }
        Page exhibitorInfoVoPage = new Page((long)exhibitorInfoPage.getPageNum(), (long)exhibitorInfoPage.getPageSize(), exhibitorInfoPage.getTotal());
        exhibitorInfoVoPage.setRecords(vos);
        vo.setExhibitorInfoVos(exhibitorInfoVoPage);
        return R.ok((Object)vo);
    }

    private void beautifyData(SmebExhibitorInfo info, ExhibitorInfoVO vo) {
        String brandName;
        String applicationIndustry = vo.getApplicationIndustry();
        if (StringUtils.isNotBlank((CharSequence)applicationIndustry)) {
            applicationIndustry = applicationIndustry.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\"", "");
            vo.setApplicationIndustry(applicationIndustry);
        }
        if (StringUtils.isNotBlank((CharSequence)(brandName = info.getBrandName()))) {
            ArrayList<String> brandNames = new ArrayList<String>();
            JSONArray json = JSONArray.fromObject((Object)brandName);
            for (int i = 0; i < json.size(); ++i) {
                JSONObject job = json.getJSONObject(i);
                brandNames.add(String.valueOf(job.get("name")));
            }
            vo.setBrandNames(brandNames);
        }
    }
}

