/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.media.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.session.MySession;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.media.entity.WebNews;
import com.ites.web.media.service.WebNewsService;
import com.ites.web.media.vo.WebNewsVO;
import com.ites.web.visit.service.WebRedeemCodeService;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.ites.web.wx.message.WxTemplateManager;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.TrackLog;
import com.joneying.web.logger.enums.ActionType;
import com.joneying.web.logger.enums.BhvType;
import com.joneying.web.logger.enums.ObjType;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.common.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65b0\u95fb\u8868 API"})
public class WebNewsController
extends BaseController {
    @Resource
    private WebNewsService webNewsService;
    @Resource
    private WxTemplateManager wxTemplateManager;
    @Resource
    private WebRedeemCodeService webRedeemCodeService;
    @Resource
    private BasicUserService basicUserService;

    @GetMapping
    @ApiOperation(value="\u53d1\u9001\u73b0\u573a\u767b\u8bb0\u5151\u6362\u7801", httpMethod="GET")
    public Result sendExchangeMessage() {
        MySession session = MyContext.session();
        if (ObjectUtils.isEmpty((Object)session)) {
            String code = this.webRedeemCodeService.generator();
            String url = "https://www.iteschina.com/zh-cn/audience/register/1?redeemCode=" + code;
            return R.ok((Object)url);
        }
        if (StringUtil.isBlank((String)session.getRedeemUrl())) {
            String openId = session.getOpenId();
            String code = this.webRedeemCodeService.generator();
            String url = this.wxTemplateManager.sendExchangeMessage(openId, code);
            session.setRedeemUrl(url);
            this.basicUserService.refreshSession(session);
            return R.ok((Object)url);
        }
        return R.ok((Object)session.getRedeemUrl());
    }

    @GetMapping
    @ApiOperation(value="\u53d1\u9001\u73b0\u573a\u767b\u8bb0\u5151\u6362\u7801", httpMethod="GET")
    public Result sendExchangeMessage(@PathVariable(value="openId") String openId) {
        String code = this.webRedeemCodeService.generator();
        String url = this.wxTemplateManager.sendExchangeMessage(openId, code);
        return R.ok((Object)url);
    }

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u67e5\u8be2\u63a8\u8350\u65b0\u95fb", httpMethod="GET")
    public Result<List<WebNewsVO>> findRecommendedNews(@PathVariable(value="id") Integer id) {
        WebNews webNews = (WebNews)this.webNewsService.getById((Serializable)id);
        Page page = this.webNewsService.findPage(new WebNews());
        List news = page.getRecords();
        Collections.shuffle(news);
        news = news.size() > 4 ? news.subList(0, 3) : news;
        List vos = BaseVO.conversion(news, WebNewsVO.class);
        return R.ok((Object)vos);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u95fb\u5206\u9875\u67e5\u8be2", httpMethod="POST")
    public Result<Page<WebNewsVO>> findPage(@RequestBody WebNews webNews) {
        webNews.setLanguage(Integer.valueOf(this.getLanguage()));
        Page page = this.webNewsService.findPage(webNews);
        Page vos = BaseVO.conversion((Page)page, WebNewsVO.class);
        return R.ok((Object)vos);
    }

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u65b0\u95fb\u8be6\u60c5", httpMethod="GET")
    @TrackLog(action=ActionType.BEHAVIOR, bhvType=BhvType.VIEW, objType=ObjType.NEW)
    public Result<WebNewsVO> findById(@PathVariable(value="id") Integer id) {
        WebNews webNews = (WebNews)this.webNewsService.getById((Serializable)id);
        this.webNewsService.addCount(id);
        WebNewsVO vo = (WebNewsVO)BaseVO.conversion((BaseEntity)webNews, WebNewsVO.class);
        return R.ok((Object)vo);
    }
}

