/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.media.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.media.entity.WebVideo;
import com.ites.web.media.service.WebVideoService;
import com.ites.web.media.vo.WebVideoVO;
import com.joneying.web.authentication.annotation.ExculdeSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.TrackLog;
import com.joneying.web.logger.enums.ActionType;
import com.joneying.web.logger.enums.BhvType;
import com.joneying.web.logger.enums.ObjType;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89c6\u9891\u8868 API"})
public class WebVideoController
extends BaseController {
    @Resource
    private WebVideoService webVideoService;

    @PostMapping
    @ExculdeSecurity
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u89c6\u9891", httpMethod="POST")
    public Result<Page<WebVideoVO>> findPage(@RequestBody WebVideo webVideo) {
        webVideo.setIsOnline(Boolean.TRUE);
        webVideo.setLanguage(Integer.valueOf(this.getLanguage()));
        Page page = this.webVideoService.findPage(webVideo);
        Page pageVOs = BaseVO.conversion((Page)page, WebVideoVO.class);
        return R.ok((Object)pageVOs);
    }

    @GetMapping
    @ExculdeSecurity
    @ApiOperation(value="\u89c6\u9891\u8be6\u60c5", httpMethod="GET")
    @TrackLog(action=ActionType.BEHAVIOR, bhvType=BhvType.VIEW, objType=ObjType.VIDEO)
    public Result<WebVideoVO> findById(@PathVariable(value="id") Integer id) {
        WebVideo webVideo = (WebVideo)this.webVideoService.getById((Serializable)id);
        this.webVideoService.addCount(id);
        WebVideoVO vo = (WebVideoVO)BaseVO.conversion((BaseEntity)webVideo, WebVideoVO.class);
        return R.ok((Object)vo);
    }

    @GetMapping
    @ExculdeSecurity
    @ApiOperation(value="\u67e5\u8be2\u63a8\u8350\u89c6\u9891", httpMethod="GET")
    public Result<List<WebVideoVO>> findRecommendedVideo(@PathVariable(value="id") Integer id) {
        ArrayList<WebVideoVO> vos = new ArrayList<WebVideoVO>();
        WebVideo webVideo = (WebVideo)this.webVideoService.getById((Serializable)id);
        List list = new ArrayList();
        Object[] label = webVideo.getLabel();
        if (!ArrayUtils.isEmpty((Object[])label)) {
            for (Object str : label) {
                list.addAll(this.webVideoService.listByLabel((String)str, id));
            }
        } else {
            list = this.webVideoService.selectRand(4, id, webVideo.getLanguage());
        }
        list = list.size() > 4 ? list.subList(0, 3) : list;
        for (WebVideo video : list) {
            WebVideoVO vo = (WebVideoVO)BaseVO.conversion((BaseEntity)video, WebVideoVO.class);
            vos.add(vo);
        }
        return R.ok(vos);
    }
}

