/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.meeting.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingChargeLog;
import com.ites.web.meeting.entity.WebMeetingChargeMode;
import com.ites.web.meeting.entity.WebMeetingEnroll;
import com.ites.web.meeting.entity.WebMeetingEnrollExtend;
import com.ites.web.meeting.service.WebMeetingChargeLogService;
import com.ites.web.meeting.service.WebMeetingChargeModeService;
import com.ites.web.meeting.service.WebMeetingEnrollService;
import com.ites.web.meeting.service.WebMeetingService;
import com.ites.web.meeting.vo.WebMeetingEnrollPayVO;
import com.ites.web.meeting.vo.WebMeetingEnrollVO;
import com.ites.web.sms.manager.SmsManager;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.IPUtil;
import com.ites.web.utils.QrcodeUtil;
import com.ites.web.utils.SnUtil;
import com.ites.web.utils.TerminalUtil;
import com.ites.web.visit.entity.ExhibitorRegistInfo;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.service.ExhibitorRegistInfoService;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.joneying.web.authentication.annotation.ExculdeLogin;
import com.joneying.web.authentication.annotation.ExculdeSecurity;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.pojo.Resp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u8bae\u62a5\u540d\u8868 API"})
@RestController
public class WebMeetingEnrollController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(WebMeetingEnrollController.class);
    @Resource
    private WebMeetingEnrollService webMeetingEnrollService;
    @Resource
    private ExhibitorRegistInfoService exhibitorRegistInfoService;
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private VisitRegistNoService visitRegistNoService;
    @Resource
    private SmsManager smsManager;
    @Autowired
    private WebMeetingChargeModeService webMeetingChargeModeService;
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private WebMeetingService webMeetingService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private WebMeetingChargeLogService webMeetingChargeLogService;
    @Value(value="${wx.pay.tradeTypePc}")
    private String tradeTypePc;
    @Value(value="${wx.pay.tradeTypeMobile}")
    private String tradeTypeMobile;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;

    @PostMapping
    @ApiOperation(value="\u6279\u91cf\u62a5\u540d", httpMethod="POST")
    public Result batchInsert(@RequestBody WebMeetingEnrollExtend webMeetingEnrollExtend) {
        List ids = webMeetingEnrollExtend.getIds();
        List meetingEnrolls = this.webMeetingEnrollService.findByUIdAndMIds(MyContext.userId(), ids);
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByUserId(MyContext.userId().intValue());
        ArrayList webMeetingEnrolls = new ArrayList();
        ids.forEach(v -> {
            Optional<WebMeetingEnroll> optional = meetingEnrolls.stream().filter(m -> m.getMeetingId().equals(v)).findFirst();
            if (!optional.isPresent()) {
                WebMeetingEnroll webMeetingEnroll = new WebMeetingEnroll();
                BeanUtils.copyProperties((Object)visitRegistInfo, (Object)webMeetingEnroll, (String[])new String[]{"source"});
                EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
                webMeetingEnroll.setSource(webMeetingEnrollExtend.getSource());
                webMeetingEnroll.setTerminal(webMeetingEnrollExtend.getTerminal());
                webMeetingEnroll.setPreRegistUrl(webMeetingEnrollExtend.getPreRegistUrl());
                webMeetingEnroll.setMeetingId(v);
                webMeetingEnrolls.add(webMeetingEnroll);
            }
        });
        if (!CollectionUtils.isEmpty(webMeetingEnrolls)) {
            this.webMeetingEnrollService.saveBatch(webMeetingEnrolls);
        }
        return R.ok();
    }

    @PostMapping
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u62a5\u540d\u72b6\u6001", httpMethod="POST")
    public Result findByMobile(@PathVariable(value="mobile") String mobile, @PathVariable(value="code") String code, @RequestBody WebMeetingEnroll params) {
        boolean validation = this.smsManager.validation(mobile, code);
        if (!validation) {
            return R.failure((String)"5002");
        }
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)params.getMeetingId());
        WebMeetingEnroll webMeetingEnroll = this.webMeetingEnrollService.findByMobileAndMeetingId(mobile, webMeeting.getId());
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByMobile(mobile);
        if (ObjectUtils.isNotEmpty((Object)webMeetingEnroll)) {
            return R.ok((Object)webMeetingEnroll);
        }
        webMeetingEnroll = new WebMeetingEnroll();
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo)) {
            BeanUtils.copyProperties((Object)visitRegistInfo, (Object)webMeetingEnroll, (String[])new String[]{"source", "userId", "id"});
            EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
            if (webMeeting.getIsCharge().booleanValue()) {
                return R.ok((Object)webMeetingEnroll);
            }
            webMeetingEnroll.setSource(params.getSource());
            webMeetingEnroll.setIndustry(params.getIndustry());
            webMeetingEnroll.setMeetingId(params.getMeetingId());
            this.webMeetingEnrollService.save((Object)webMeetingEnroll);
            return R.ok((Object)webMeetingEnroll);
        }
        return R.ok();
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u4f1a\u8bae\u62a5\u540d\u4fe1\u606f", httpMethod="POST")
    public Result insert(@RequestBody WebMeetingEnroll webMeetingEnroll) {
        WebMeetingChargeMode chargeMode;
        Resp resp;
        WebMeetingEnroll byUIdAndMId = this.webMeetingEnrollService.findByUIdAndMId(MyContext.userId(), webMeetingEnroll.getMeetingId());
        if (ObjectUtils.isNotEmpty((Object)byUIdAndMId)) {
            return R.ok((Object)byUIdAndMId);
        }
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)webMeetingEnroll.getMeetingId());
        if (Objects.isNull(webMeeting)) {
            return R.failure();
        }
        if (!this.validateData(webMeetingEnroll)) {
            return R.failure((String)"5302");
        }
        if (!Objects.isNull(webMeeting.getIsIdentity()) && webMeeting.getIsIdentity().booleanValue() && WebConstant.IDENTITY_CARD_TYPE.equals(webMeetingEnroll.getIdentityCardType()) && !"200".equals((resp = this.identityCardServiceExport.identityCard(webMeetingEnroll.getIdentityCard(), webMeetingEnroll.getName())).getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
        webMeetingEnroll.setUserId(MyContext.userId());
        if (webMeeting.getIsCharge().booleanValue() && (chargeMode = (WebMeetingChargeMode)this.webMeetingChargeModeService.getById((Serializable)webMeetingEnroll.getChargeModeId())).getAmount() == 0) {
            webMeetingEnroll.setChargeStatus(Boolean.valueOf(true));
        }
        this.webMeetingEnrollService.save((Object)webMeetingEnroll);
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByMobile(webMeetingEnroll.getMobile());
        if (ObjectUtils.isEmpty((Object)visitRegistInfo)) {
            visitRegistInfo = this.buildVisit(webMeetingEnroll);
            this.visitRegistInfoService.save((Object)visitRegistInfo);
        }
        if (!webMeeting.getIsCharge().booleanValue()) {
            this.webMeetingEnrollService.sendMessage(webMeetingEnroll);
        }
        WebMeetingEnrollVO vo = (WebMeetingEnrollVO)BaseVO.conversion((BaseEntity)webMeetingEnroll, WebMeetingEnrollVO.class);
        return R.ok((Object)vo);
    }

    private boolean validateData(WebMeetingEnroll webMeetingEnroll) {
        return ObjectUtils.allNotNull((Object[])new Object[]{webMeetingEnroll.getName(), webMeetingEnroll.getEmail(), webMeetingEnroll.getCompany(), webMeetingEnroll.getIndustry(), webMeetingEnroll.getPosition(), webMeetingEnroll.getProvince(), webMeetingEnroll.getCity(), webMeetingEnroll.getAddress(), webMeetingEnroll.getDepartment()});
    }

    private VisitRegistInfo buildVisit(WebMeetingEnroll webMeetingEnroll) {
        VisitRegistInfo visitRegistInfo = new VisitRegistInfo();
        BeanUtils.copyProperties((Object)webMeetingEnroll, (Object)visitRegistInfo);
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN);
        visitRegistInfo.setNumbers(WebConstant.NUMBER);
        visitRegistInfo.setCardNo(cardNo);
        visitRegistInfo.setTerminal(TerminalUtil.termainal((String)this.request.getHeader("User-Agent")));
        visitRegistInfo.setUserId(MyContext.userId());
        visitRegistInfo.setIp(IPUtil.getIP((HttpServletRequest)this.request));
        if (StringUtils.isBlank((CharSequence)visitRegistInfo.getSource())) {
            visitRegistInfo.setSource("meeting_enroll");
        }
        return visitRegistInfo;
    }

    @PostMapping
    @ApiOperation(value="\u7f34\u8d39", httpMethod="POST")
    public Result pay(@RequestBody WebMeetingEnroll params) throws WxPayException, IOException {
        if (Objects.isNull(params.getMeetingId()) || Objects.isNull(params.getChargeModeId()) || Objects.isNull(params.getTerminal()) || Objects.isNull(params.getMobile())) {
            return R.failure((String)"\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (params.getTerminal().equals(WebConstant.TERMAINAL_MOBILE) && Objects.isNull(MyContext.session().getOpenId())) {
            return R.failure((String)"501", (String)"\u8bf7\u4f7f\u7528\u624b\u673a\u5fae\u4fe1\u6d4f\u89c8\u5668\u8fdb\u884c\u4ed8\u6b3e");
        }
        Integer terminal = params.getTerminal();
        WebMeetingChargeMode chargeMode = (WebMeetingChargeMode)this.webMeetingChargeModeService.getById((Serializable)params.getChargeModeId());
        WebMeetingEnroll webMeetingEnroll = this.webMeetingEnrollService.findByMobileAndMeetingId(params.getMobile(), params.getMeetingId());
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)webMeetingEnroll.getMeetingId());
        WxPayUnifiedOrderRequest orderRequest = this.buildWxPayRequest(webMeeting, chargeMode.getAmount(), terminal);
        this.addWebMeetingChargeLog(orderRequest, webMeetingEnroll);
        Object payResult = this.wxPayService.createOrder(orderRequest);
        WebMeetingEnrollPayVO vo = new WebMeetingEnrollPayVO();
        vo.setTerminal(terminal);
        if (terminal.equals(WebConstant.TERMAINAL_MOBILE)) {
            vo.setData(payResult);
        }
        if (terminal.equals(WebConstant.TERMAINAL_PC)) {
            String codeUrl = ((WxPayNativeOrderResult)payResult).getCodeUrl();
            vo.setData((Object)QrcodeUtil.createPayQRCode((String)codeUrl, (String)orderRequest.getOutTradeNo(), (int)300, (int)300, (String)"cn"));
            vo.setAmount(orderRequest.getTotalFee());
        }
        return R.ok((Object)vo);
    }

    public WebMeetingChargeLog addWebMeetingChargeLog(WxPayUnifiedOrderRequest orderRequest, WebMeetingEnroll webMeetingEnroll) {
        WebMeetingChargeLog chargeLog = WebMeetingChargeLog.builder().chargeModelId(webMeetingEnroll.getChargeModeId()).userId(MyContext.userId()).meetingId(webMeetingEnroll.getMeetingId()).amount(orderRequest.getTotalFee()).outTradeNo(orderRequest.getOutTradeNo()).productId(orderRequest.getProductId()).tradeType(orderRequest.getTradeType()).createTime(LocalDateTime.now()).build();
        this.webMeetingChargeLogService.save((Object)chargeLog);
        webMeetingEnroll.setChargeLogId(chargeLog.getId());
        this.webMeetingEnrollService.updateById((Object)webMeetingEnroll);
        return chargeLog;
    }

    public WxPayUnifiedOrderRequest buildWxPayRequest(WebMeeting webMeeting, Integer amount, Integer terminal) {
        WxPayUnifiedOrderRequest orderRequest = new WxPayUnifiedOrderRequest();
        orderRequest.setBody(webMeeting.getTitle().concat("-\u62a5\u540d\u8d39"));
        orderRequest.setOutTradeNo(SnUtil.generate());
        orderRequest.setProductId(webMeeting.getId().toString());
        orderRequest.setTotalFee(amount);
        orderRequest.setSpbillCreateIp(IPUtil.getIP((HttpServletRequest)this.request));
        orderRequest.setNotifyUrl("https://web.iteschina.com/web/meeting/enroll/payCallBack");
        if (terminal.equals(WebConstant.TERMAINAL_MOBILE)) {
            orderRequest.setTradeType(this.tradeTypeMobile);
            orderRequest.setOpenid(MyContext.session().getOpenId());
        } else if (terminal.equals(WebConstant.TERMAINAL_PC)) {
            orderRequest.setTradeType(this.tradeTypePc);
        }
        return orderRequest;
    }

    @PostMapping
    @ApiOperation(value="\u67e5\u8be2\u652f\u4ed8\u72b6\u6001", httpMethod="POST")
    public Result findChargeMeetingEnroll(@RequestBody WebMeetingEnroll params) {
        WebMeetingEnroll webMeetingEnroll = this.webMeetingEnrollService.findByMobileAndMeetingId(params.getMobile(), params.getMeetingId());
        return R.ok((Object)webMeetingEnroll);
    }

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u4f1a\u8bae\u62a5\u540d-\u7528\u4e8e\u975e\u5c55\u671f\u7b7e\u5230\u7cfb\u7edf\uff08\u4e0d\u6821\u9a8c\u624b\u673a\u53f7\u7801\u3001\u65e0\u767b\u5f55\u6001\uff09", httpMethod="POST")
    public Result noStatusInsert(@RequestBody WebMeetingEnroll webMeetingEnroll) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{webMeetingEnroll.getMobile(), webMeetingEnroll.getName()})) {
            return R.failure();
        }
        webMeetingEnroll.setSign(Boolean.valueOf(true));
        EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
        this.webMeetingEnrollService.save((Object)webMeetingEnroll);
        WebMeetingEnrollVO vo = (WebMeetingEnrollVO)BaseVO.conversion((BaseEntity)webMeetingEnroll, WebMeetingEnrollVO.class);
        return R.ok((Object)vo);
    }

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u4f1a\u8bae\u7b7e\u5230", httpMethod="POST")
    public Result sign(@PathVariable(value="type") int type, @RequestBody WebMeetingEnroll params) {
        WebMeetingEnroll webMeetingEnroll = this.webMeetingEnrollService.findByMobileAndMeetingId(params.getMobile(), params.getMeetingId());
        if (!Objects.isNull(webMeetingEnroll)) {
            webMeetingEnroll.setSign(Boolean.valueOf(true));
            this.webMeetingEnrollService.updateById((Object)webMeetingEnroll);
        } else {
            VisitRegistInfo info = this.visitRegistInfoService.findByMobile(params.getMobile());
            if (!Objects.isNull(info)) {
                webMeetingEnroll = new WebMeetingEnroll();
                BeanUtils.copyProperties((Object)info, (Object)webMeetingEnroll);
                webMeetingEnroll.setMeetingId(params.getMeetingId());
                webMeetingEnroll.setSign(Boolean.valueOf(true));
                webMeetingEnroll.setSource("\u73b0\u573a\u89c2\u4f17");
                EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
                this.webMeetingEnrollService.save((Object)webMeetingEnroll);
            } else {
                ExhibitorRegistInfo exhibitorRegistInfo = this.exhibitorRegistInfoService.findByMobile(params.getMobile());
                if (!Objects.isNull(exhibitorRegistInfo)) {
                    webMeetingEnroll = new WebMeetingEnroll();
                    BeanUtils.copyProperties((Object)exhibitorRegistInfo, (Object)webMeetingEnroll);
                    webMeetingEnroll.setMeetingId(params.getMeetingId());
                    webMeetingEnroll.setSign(Boolean.valueOf(true));
                    webMeetingEnroll.setSource("\u73b0\u573a\u5c55\u5546");
                    EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
                    this.webMeetingEnrollService.save((Object)webMeetingEnroll);
                }
            }
        }
        WebMeetingEnrollVO vo = (WebMeetingEnrollVO)BaseVO.conversion((BaseEntity)webMeetingEnroll, WebMeetingEnrollVO.class);
        return R.ok((Object)vo);
    }

    @ExculdeLogin
    @ExculdeSecurity
    @PostMapping
    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u7ed3\u679c\u56de\u8c03", httpMethod="POST")
    public String payCallBack() {
        try {
            String xmlResult = IOUtils.toString((InputStream)this.request.getInputStream(), (String)this.request.getCharacterEncoding());
            WxPayOrderNotifyResult wxPayOrderNotifyResult = this.wxPayService.parseOrderNotifyResult(xmlResult);
            String outTradeNo = wxPayOrderNotifyResult.getOutTradeNo();
            WebMeetingChargeLog meetingChargeLog = this.webMeetingChargeLogService.findByOutTradeNo(outTradeNo);
            if (meetingChargeLog == null) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u70b9\u8ba2\u5355\u7f16\u53f7");
            }
            if (meetingChargeLog.getPayStatus().booleanValue()) {
                return WxPayNotifyResponse.success((String)"\u6210\u529f");
            }
            meetingChargeLog.setPayStatus(Boolean.TRUE);
            meetingChargeLog.setUpdateTime(LocalDateTime.now());
            meetingChargeLog.setPayTime(LocalDateTime.now());
            this.webMeetingChargeLogService.updateById((Object)meetingChargeLog);
            WebMeetingEnroll webMeetingEnroll = this.webMeetingEnrollService.findByChargeLogId(meetingChargeLog.getId());
            webMeetingEnroll.setChargeStatus(Boolean.TRUE);
            meetingChargeLog.setUpdateTime(LocalDateTime.now());
            this.webMeetingEnrollService.updateById((Object)webMeetingEnroll);
            this.webMeetingEnrollService.sendMessage(webMeetingEnroll);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }
}

