/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.prize.controller;

import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.prize.entity.PrizeLightLog;
import com.ites.web.prize.entity.PrizeLightNo;
import com.ites.web.prize.entity.PrizeLightPosition;
import com.ites.web.prize.service.PrizeLightLogService;
import com.ites.web.prize.service.PrizeLightNoService;
import com.ites.web.prize.service.PrizeLightPositionService;
import com.ites.web.prize.vo.PrizeLightLogVO;
import com.ites.web.prize.vo.PrizeLightPositionVO;
import com.ites.web.prize.vo.PrizeLightVO;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.visit.entity.WebRedeemCode;
import com.ites.web.visit.service.WebRedeemCodeService;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.common.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e2d\u5956\u65e5\u5fd7\u8868 API"})
public class PrizeLightLogController
extends BaseController {
    @Resource
    private PrizeLightLogService prizeLightLogService;
    @Resource
    private PrizeLightPositionService prizeLightPositionService;
    @Autowired
    private PrizeLightNoService prizeLightNoService;
    @Autowired
    private WebRedeemCodeService webRedeemCodeService;

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u70b9\u4eaeITES", notes="\u70b9\u4eaeITES")
    public Result toLight(@PathVariable(value="boothId") String boothId) {
        String openId = this.request.getHeader("openId");
        if (StringUtil.isBlank((String)openId)) {
            return R.failure((String)"5501");
        }
        PrizeLightPosition prizeLightPosition = new PrizeLightPosition();
        prizeLightPosition.setBoothId(boothId);
        prizeLightPosition.setOpenId(openId);
        EntityDateUtil.supplementInsert((BaseEntity)prizeLightPosition);
        this.prizeLightPositionService.save((Object)prizeLightPosition);
        List list = this.prizeLightPositionService.listByOpenId(openId);
        List vos = BaseVO.conversion((List)list, PrizeLightPositionVO.class);
        return R.ok((Object)vos);
    }

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u6838\u9500", httpMethod="GET")
    public Result verification(@PathVariable(value="no") Integer no) {
        PrizeLightLog prizeLightLog = this.prizeLightLogService.findByNo(no);
        if (prizeLightLog == null) {
            return R.failure((String)"5502");
        }
        if (prizeLightLog.getIsApply().booleanValue()) {
            return R.failure((String)"5503");
        }
        this.prizeLightLogService.updateApplyStatus(prizeLightLog);
        PrizeLightLogVO vo = (PrizeLightLogVO)BaseVO.conversion((BaseEntity)prizeLightLog, PrizeLightLogVO.class);
        return R.ok((Object)vo);
    }

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u62bd\u5956", httpMethod="GET")
    public Result goToPrize() {
        String openId = this.request.getHeader("openId");
        this.logger.debug("PrizeLightController:openId=================>" + openId);
        if (StringUtil.isBlank((String)openId)) {
            return R.failure();
        }
        PrizeLightLog prizeLightLog = this.prizeLightLogService.goToPrize(openId);
        if (prizeLightLog == null) {
            return R.failure();
        }
        PrizeLightLogVO vo = (PrizeLightLogVO)BaseVO.conversion((BaseEntity)prizeLightLog, PrizeLightLogVO.class);
        return R.ok((Object)vo);
    }

    @GetMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u62bd\u5956", notes="\u5224\u65ad\u662f\u5426\u62bd\u5956")
    public Result toPrizeByOpenId() {
        String openId = this.request.getHeader("openId");
        if (StringUtil.isBlank((String)openId)) {
            return R.failure((String)"5501");
        }
        PrizeLightVO vo = new PrizeLightVO();
        PrizeLightLog prizeLightLog = this.prizeLightLogService.findByOpenId(openId);
        if (prizeLightLog != null) {
            PrizeLightLogVO logVo = (PrizeLightLogVO)BaseVO.conversion((BaseEntity)prizeLightLog, PrizeLightLogVO.class);
            vo.setLogVo(logVo);
        }
        List list = this.prizeLightPositionService.listByOpenId(openId);
        List positionVos = BaseVO.conversion((List)list, PrizeLightPositionVO.class);
        vo.setPositionVos(positionVos);
        return R.ok((Object)vo);
    }

    @PostMapping
    @ApiOperation(value="\u751f\u6210\u6253\u5361\u6d3b\u52a8\u793c\u54c1\u5151\u6362\u7801", httpMethod="POST")
    public Result generatePrizeNo(Integer begin, Integer end, Integer step) {
        int count = (end - begin) / step;
        ArrayList<PrizeLightNo> prizeLightNos = new ArrayList<PrizeLightNo>();
        for (int i = 0; i < count; ++i) {
            int random = new Random().nextInt(step);
            int cardNo = begin + random;
            begin = begin + step;
            PrizeLightNo prizeLightNo = new PrizeLightNo();
            prizeLightNo.setNo(this.supplementPrizeNo(Integer.valueOf(cardNo)));
            prizeLightNos.add(prizeLightNo);
        }
        boolean result = this.prizeLightNoService.saveBatch(prizeLightNos);
        return R.ok((Object)result);
    }

    @PostMapping
    @ApiOperation(value="\u751f\u6210\u7ebf\u4e0b\u53c2\u89c2\u7801", httpMethod="POST")
    public Result generateRedeemCode(Integer begin, Integer end, Integer step) {
        int count = (end - begin) / step;
        ArrayList<WebRedeemCode> webRedeemCodes = new ArrayList<WebRedeemCode>();
        for (int i = 0; i < count; ++i) {
            int random = new Random().nextInt(step);
            int cardNo = begin + random;
            begin = begin + step;
            WebRedeemCode webRedeemCode = new WebRedeemCode();
            webRedeemCode.setCode(this.supplementRedeemCode(Integer.valueOf(cardNo)));
            webRedeemCode.setStatus(Integer.valueOf(1));
            webRedeemCodes.add(webRedeemCode);
        }
        boolean result = this.webRedeemCodeService.saveBatch(webRedeemCodes);
        return R.ok((Object)result);
    }

    public String supplementPrizeNo(Integer no) {
        StringBuffer buffer = new StringBuffer(String.valueOf(no));
        StringBuffer supplement = new StringBuffer();
        int n = 5 - buffer.length();
        if (n == 0) {
            return buffer.toString();
        }
        for (int i = 0; i < n; ++i) {
            supplement.append("0");
        }
        supplement.append(buffer);
        return supplement.toString();
    }

    public String supplementRedeemCode(Integer no) {
        StringBuffer buffer = new StringBuffer(String.valueOf(no));
        StringBuffer supplement = new StringBuffer();
        int n = 6 - buffer.length();
        if (n == 0) {
            return buffer.toString();
        }
        for (int i = 0; i < n; ++i) {
            supplement.append("0");
        }
        supplement.append(buffer);
        return supplement.toString();
    }
}

